/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.IgnoreTransactionTracerFactory;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PointCut
implements Comparable<PointCut>,
ClassAndMethodMatcher {
    protected static final int HIGH_PRIORITY = Integer.MAX_VALUE;
    protected static final int DEFAULT_PRIORITY = 20;
    protected static final int LOW_PRIORITY = Integer.MIN_VALUE;
    private final ClassMatcher classMatcher;
    private final MethodMatcher methodMatcher;
    private final PointCutConfiguration config;
    private int priority = 20;
    private final boolean isIgnoreTransaction;

    protected PointCut(PointCutConfiguration config, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        assert (config != null);
        this.classMatcher = classMatcher;
        this.methodMatcher = methodMatcher;
        this.config = config;
        this.isIgnoreTransaction = config.getConfiguration().getProperty("ignore_transaction", false);
    }

    @Override
    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    protected void logInstrumentation(String className, Class<?> classBeingRedefined) {
        if (Agent.isDebugEnabled()) {
            Agent.LOG.finer(MessageFormat.format("Instrumenting {0} {1}", className, classBeingRedefined == null ? "" : "(Second pass)"));
        }
    }

    @Override
    public ClassMatcher getClassMatcher() {
        return this.classMatcher;
    }

    protected boolean isDispatcher() {
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    protected void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public final int compareTo(PointCut pc) {
        return this.getPriority() - pc.getPriority();
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
    }

    protected abstract PointCutInvocationHandler getPointCutInvocationHandlerImpl();

    public final PointCutInvocationHandler getPointCutInvocationHandler() {
        return this.wrapHandler(this.isIgnoreTransaction() ? new IgnoreTransactionTracerFactory() : this.getPointCutInvocationHandlerImpl());
    }

    private PointCutInvocationHandler wrapHandler(final PointCutInvocationHandler pointCutInvocationHandler) {
        if (this.isDispatcher() || !(pointCutInvocationHandler instanceof TracerFactory)) {
            return pointCutInvocationHandler;
        }
        return new TracerFactory(){

            public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
                if (!PointCut.this.isDispatcher() && !transaction.isStarted()) {
                    return null;
                }
                if (transaction.getTransactionActivity().isFlyweight()) {
                    return null;
                }
                return ((TracerFactory)pointCutInvocationHandler).getTracer(transaction, sig, object, args);
            }
        };
    }

    protected boolean isIgnoreTransaction() {
        return this.isIgnoreTransaction;
    }

    public String toString() {
        return this.config.getName() == null ? "PointCut:" + this.getPointCutInvocationHandler().getClass().getName() : this.config.getName();
    }

    protected static MethodMatcher createMethodMatcher(MethodMatcher ... matchers) {
        return OrMethodMatcher.getMethodMatcher(matchers);
    }

    protected static MethodMatcher createExactMethodMatcher(String methodName, String ... methodDescriptions) {
        return new ExactMethodMatcher(methodName, methodDescriptions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classMatcher == null ? 0 : this.classMatcher.hashCode());
        result = 31 * result + (this.methodMatcher == null ? 0 : this.methodMatcher.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointCut other = (PointCut)obj;
        if (this.classMatcher == null ? other.classMatcher != null : !this.classMatcher.equals(other.classMatcher)) {
            return false;
        }
        return !(this.methodMatcher == null ? other.methodMatcher != null : !this.methodMatcher.equals(other.methodMatcher));
    }
}

