/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.base.Supplier;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Multimap;
import com.newrelic.agent.deps.com.google.common.collect.Multimaps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.TraceDetailsList;
import com.newrelic.agent.instrumentation.context.TraceInformation;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.util.asm.BenignClassReadException;
import com.newrelic.agent.util.asm.ClassResolver;
import com.newrelic.agent.util.asm.ClassResolvers;
import com.newrelic.agent.util.asm.Utils;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationContext
implements TraceDetailsList {
    private static final TraceInformation EMPTY_TRACE_INFO = new TraceInformation();
    protected final byte[] bytes;
    private boolean modified;
    private Multimap<Method, String> weavedMethods;
    protected boolean print;
    private Set<Method> timedMethods;
    private Map<Method, PointCut> oldInstrumentationMethods;
    private TraceInformation tracedInfo;
    private Map<ClassMatchVisitorFactory, OptimizedClassMatcher.Match> matches;
    private Map<Method, Method> bridgeMethods;
    private final Class<?> classBeingRedefined;
    private final ProtectionDomain protectionDomain;
    private List<ClassResolver> classResolvers;
    private boolean generated;
    private boolean hasSource;

    public InstrumentationContext(byte[] bytes, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
        this.bytes = bytes;
        this.classBeingRedefined = classBeingRedefined;
        this.protectionDomain = protectionDomain;
    }

    public Class<?> getClassBeingRedefined() {
        return this.classBeingRedefined;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public void markAsModified() {
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public TraceInformation getTraceInformation() {
        return this.tracedInfo == null ? EMPTY_TRACE_INFO : this.tracedInfo;
    }

    public boolean isTracerMatch() {
        return this.tracedInfo != null && this.tracedInfo.isMatch();
    }

    public void addWeavedMethod(Method method, String instrumentationTitle) {
        if (this.weavedMethods == null) {
            this.weavedMethods = Multimaps.newSetMultimap(Maps.newHashMap(), new Supplier<Set<String>>(){

                @Override
                public Set<String> get() {
                    return Sets.newHashSet();
                }
            });
        }
        this.weavedMethods.put(method, instrumentationTitle);
        this.modified = true;
    }

    public void printBytecode() {
        this.print = true;
    }

    public Map<Method, PointCut> getOldInstrumentationMethods() {
        return this.oldInstrumentationMethods == null ? Collections.emptyMap() : this.oldInstrumentationMethods;
    }

    public Set<Method> getWeavedMethods() {
        return this.weavedMethods == null ? Collections.emptySet() : this.weavedMethods.keySet();
    }

    public Set<Method> getTimedMethods() {
        return this.timedMethods == null ? Collections.emptySet() : this.timedMethods;
    }

    public Collection<String> getMergeInstrumentationPackages(Method method) {
        return this.weavedMethods == null ? Collections.emptySet() : this.weavedMethods.asMap().get(method);
    }

    public boolean isModified(Method method) {
        return this.getTimedMethods().contains(method) || this.getWeavedMethods().contains(method);
    }

    public void addTimedMethods(Method ... methods) {
        if (this.timedMethods == null) {
            this.timedMethods = Sets.newHashSet();
        }
        Collections.addAll(this.timedMethods, methods);
        this.modified = true;
    }

    public void addOldInstrumentationMethod(Method method, PointCut pointCut) {
        if (this.oldInstrumentationMethods == null) {
            this.oldInstrumentationMethods = Maps.newHashMap();
        }
        this.oldInstrumentationMethods.put(method, pointCut);
        this.modified = true;
    }

    public Map<ClassMatchVisitorFactory, OptimizedClassMatcher.Match> getMatches() {
        return this.matches == null ? Collections.emptyMap() : this.matches;
    }

    byte[] processTransformBytes(byte[] originalBytes, byte[] newBytes) {
        if (null != newBytes) {
            this.markAsModified();
            return newBytes;
        }
        return originalBytes;
    }

    public void putTraceAnnotation(Method method, TraceDetails traceDetails) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.putTraceAnnotation(method, traceDetails);
    }

    public void addIgnoreApdexMethod(String methodName, String methodDesc) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.addIgnoreApdexMethod(methodName, methodDesc);
    }

    public void addIgnoreTransactionMethod(String methodName, String methodDesc) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.addIgnoreTransactionMethod(methodName, methodDesc);
    }

    public void addIgnoreTransactionMethod(Method m) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.addIgnoreTransactionMethod(m);
    }

    public void putMatch(ClassMatchVisitorFactory matcher, OptimizedClassMatcher.Match match) {
        if (this.matches == null) {
            this.matches = Maps.newHashMap();
        }
        this.matches.put(matcher, match);
    }

    public void addTracedMethods(Map<Method, TraceDetails> tracedMethods) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.pullAll(tracedMethods);
    }

    @Override
    public void addTrace(Method method, TraceDetails traceDetails) {
        if (this.tracedInfo == null) {
            this.tracedInfo = new TraceInformation();
        }
        this.tracedInfo.putTraceAnnotation(method, traceDetails);
    }

    public void match(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, Collection<ClassMatchVisitorFactory> classVisitorFactories) {
        ClassVisitor visitor = null;
        for (ClassMatchVisitorFactory factory : classVisitorFactories) {
            ClassVisitor nextVisitor = factory.newClassMatchVisitor(loader, classBeingRedefined, reader, visitor, this);
            if (nextVisitor == null) continue;
            visitor = nextVisitor;
        }
        if (visitor != null) {
            reader.accept(visitor, 1);
            if (this.bridgeMethods != null) {
                this.resolveBridgeMethods(reader);
            } else {
                this.bridgeMethods = ImmutableMap.of();
            }
        }
    }

    private void resolveBridgeMethods(ClassReader reader) {
        ClassVisitor visitor = new ClassVisitor(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final Method method = new Method(name, desc);
                if (InstrumentationContext.this.bridgeMethods.containsKey(method)) {
                    return new MethodVisitor(327680){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            InstrumentationContext.this.bridgeMethods.put(method, new Method(name, desc));
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return null;
            }
        };
        reader.accept(visitor, 6);
    }

    public static Set<Class<?>> getMatchingClasses(Collection<ClassMatchVisitorFactory> matchers, Class<?> ... classes) {
        HashSet<Class<?>> matchingClasses = Sets.newHashSet();
        for (Class<?> clazz : classes) {
            if (!InstrumentationContext.isMatch(matchers, clazz)) continue;
            matchingClasses.add(clazz);
        }
        return matchingClasses;
    }

    private static boolean isMatch(Collection<ClassMatchVisitorFactory> matchers, Class<?> clazz) {
        if (clazz.isArray()) {
            return false;
        }
        if (clazz.getName().startsWith("com.newrelic.api.agent") || clazz.getName().startsWith("com.newrelic.agent.bridge")) {
            return false;
        }
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        InstrumentationContext context = new InstrumentationContext(null, null, null);
        try {
            ClassReader reader = Utils.readClass(clazz);
            context.match(loader, clazz, reader, matchers);
            return !context.getMatches().isEmpty();
        }
        catch (BenignClassReadException ex) {
            return false;
        }
        catch (Exception ex) {
            if (clazz.getName().startsWith("com.newrelic") || clazz.getName().startsWith("weave.")) {
                return false;
            }
            Agent.LOG.log(Level.FINER, "Unable to read {0}", new Object[]{clazz.getName()});
            Agent.LOG.log(Level.FINEST, ex, "Unable to read {0}", new Object[]{clazz.getName()});
            return false;
        }
    }

    public void addBridgeMethod(Method method) {
        if (this.bridgeMethods == null) {
            this.bridgeMethods = Maps.newHashMap();
        }
        this.bridgeMethods.put(method, method);
    }

    public Map<Method, Method> getBridgeMethods() {
        return this.bridgeMethods;
    }

    public boolean isUsingLegacyInstrumentation() {
        return !this.getOldInstrumentationMethods().isEmpty();
    }

    public void addClassResolver(ClassResolver classResolver) {
        if (this.classResolvers == null) {
            this.classResolvers = Lists.newArrayList();
        }
        this.classResolvers.add(classResolver);
    }

    public ClassResolver getClassResolver(ClassLoader loader) {
        ClassResolver classResolver = ClassResolvers.getClassLoaderResolver(loader);
        if (this.classResolvers != null) {
            this.classResolvers.add(classResolver);
            classResolver = ClassResolvers.getMultiResolver(this.classResolvers);
        }
        return classResolver;
    }

    public byte[] getOriginalClassBytes() {
        return this.bytes;
    }

    public void setGenerated(boolean isGenerated) {
        this.generated = isGenerated;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setSourceAttribute(boolean hasSource) {
        this.hasSource = hasSource;
    }

    public boolean hasSourceAttribute() {
        return this.hasSource;
    }
}

