/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;

@PointCut
public class ProcessPointCut
extends TracerFactoryPointCut {
    public static final String UNIXPROCESS_CLASS_NAME = "java/lang/UNIXProcess";
    public static final String PROCESS_IMPL_CLASS_NAME = "java/lang/ProcessImpl";

    public ProcessPointCut(ClassTransformer classTransformer) {
        super(ProcessPointCut.class, ExactClassMatcher.or(PROCESS_IMPL_CLASS_NAME, UNIXPROCESS_CLASS_NAME), ProcessPointCut.createExactMethodMatcher("waitFor", "()I"));
        classTransformer.getClassNameFilter().addIncludeClass(PROCESS_IMPL_CLASS_NAME);
        classTransformer.getClassNameFilter().addIncludeClass(UNIXPROCESS_CLASS_NAME);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        return new DefaultTracer(transaction, sig, object, new ClassMethodMetricNameFormat(sig, object));
    }
}

