/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.akka;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionHolder;
import com.newrelic.agent.async.AsyncTransactionState;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.NameMethodMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.text.MessageFormat;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class AkkaTransactionHolderInitPointCut
extends PointCut
implements EntryInvocationHandler {
    public static final boolean DEFAULT_ENABLED = true;
    private static final String POINT_CUT_NAME = AkkaTransactionHolderInitPointCut.class.getName();

    public AkkaTransactionHolderInitPointCut(ClassTransformer classTransformer) {
        super(AkkaTransactionHolderInitPointCut.createPointCutConfig(), AkkaTransactionHolderInitPointCut.createClassMatcher(), AkkaTransactionHolderInitPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "akka_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return OrClassMatcher.getClassMatcher(new ExactClassMatcher("akka/dispatch/Envelope"), new ExactClassMatcher("akka/dispatch/AbstractPromise"), new ExactClassMatcher("akka/dispatch/Future$$anon$4"));
    }

    private static MethodMatcher createMethodMatcher() {
        return new NameMethodMatcher("<init>");
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (object instanceof TransactionHolder) {
            TransactionHolder th = (TransactionHolder)object;
            if (Transaction.hasTransaction() && th._nr_getTransaction() == null) {
                Transaction tx = Transaction.getTransaction();
                if (!(tx.getTransactionState() instanceof AsyncTransactionState)) {
                    return;
                }
                th._nr_setTransaction(tx);
                if (args.length > 1) {
                    String akkaOrigin = args[1].toString();
                    akkaOrigin = akkaOrigin.replaceAll("\\$[^/\\]]+", "");
                    akkaOrigin = akkaOrigin.replace("/", "\\");
                    akkaOrigin = akkaOrigin.replace(".", "_");
                    th._nr_setName(MessageFormat.format("Java/{0}/tell", akkaOrigin));
                }
                tx.getTransactionState().asyncJobStarted(th);
            }
        }
    }
}

