/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.amazon;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.amazon.AbstractJetS3tPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.Tracer;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class JetS3tBucketPointCut
extends AbstractJetS3tPointCut {
    public JetS3tBucketPointCut(ClassTransformer classTransformer) {
        super(JetS3tBucketPointCut.class, new ExactMethodMatcher("listObjects", "(Lorg/jets3t/service/model/S3Bucket;)[Lorg/jets3t/service/model/S3Object;", "(Lorg/jets3t/service/model/S3Bucket;Ljava/lang/String;Ljava/lang/String;)[Lorg/jets3t/service/model/S3Object;", "(Lorg/jets3t/service/model/S3Bucket;Ljava/lang/String;Ljava/lang/String;J)[Lorg/jets3t/service/model/S3Object;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)[Lorg/jets3t/service/model/S3Object;"), new ExactMethodMatcher("createBucket", "(Ljava/lang/String;Ljava/lang/String;)Lorg/jets3t/service/model/S3Bucket;", "(Ljava/lang/String;)Lorg/jets3t/service/model/S3Bucket;", "(Lorg/jets3t/service/model/S3Bucket;)Lorg/jets3t/service/model/S3Bucket;"), new ExactMethodMatcher("deleteBucket", "(Lorg/jets3t/service/model/S3Bucket;)V", "(Ljava/lang/String;)V"), new ExactMethodMatcher("deleteObject", "(Lorg/jets3t/service/model/S3Bucket;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V"), new ExactMethodMatcher("getObject", "(Lorg/jets3t/service/model/S3Bucket;Ljava/lang/String;)Lorg/jets3t/service/model/S3Object;", "(Lorg/jets3t/service/model/S3Bucket;Ljava/lang/String;Ljava/util/Calendar;Ljava/util/Calendar;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)Lorg/jets3t/service/model/S3Object;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Calendar;Ljava/util/Calendar;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)Lorg/jets3t/service/model/S3Object;"), new ExactMethodMatcher("putObject", "(Ljava/lang/String;Lorg/jets3t/service/model/S3Object;)Lorg/jets3t/service/model/S3Object;", "(Lorg/jets3t/service/model/S3Bucket;Lorg/jets3t/service/model/S3Object;)Lorg/jets3t/service/model/S3Object;"), new ExactMethodMatcher("copyObject", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jets3t/service/model/S3Object;ZLjava/util/Calendar;Ljava/util/Calendar;[Ljava/lang/String;[Ljava/lang/String;)Ljava/util/Map;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jets3t/service/model/S3Object;Z)Ljava/util/Map;"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object service, Object[] args) {
        String uri;
        String host = null;
        try {
            host = this.getHost(service);
            uri = this.getUri(service);
        }
        catch (Exception e) {
            if (host == null) {
                host = "storage";
            }
            uri = "";
            String msg = MessageFormat.format("Instrumentation error invoking {0} in {1}: {2}", sig, this.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.log(Level.FINE, msg);
        }
        return new ExternalComponentTracer(transaction, sig, service, host, "Jets3t", uri, sig.getMethodName(), args[0].toString());
    }
}

