/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentUtils;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpCommonsPointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpMethodBase;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpMethodExtension;
import com.newrelic.agent.instrumentation.pointcuts.commons.NameValuePair;
import com.newrelic.agent.instrumentation.pointcuts.commons.Protocol;
import com.newrelic.agent.instrumentation.pointcuts.commons.URI;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.MethodCache;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.OutboundHeaders;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class HttpMethodBasePointCut
extends HttpCommonsPointCut {
    private static final int HOST_DELIMITER = 58;
    private static final String HTTPCONNECTION_CLASS_NAME = "com/newrelic/agent/deps/org/apache/commons/httpclient/HttpConnection";
    private static final String GET_HOST_METHOD_NAME = "getHost";
    private static final String GET_HOST_METHOD_DESC = "()V";
    private static final String GET_PORT_METHOD_NAME = "getPort";
    private static final String GET_PORT_METHOD_DESC = "()I";
    private static final String GET_PROTOCOL_METHOD_NAME = "getProtocol";
    private static final String GET_PROTOCOL_METHOD_DESC = "()Lorg/apache/commons/httpclient/protocol/Protocol;";
    private static final int DEFAULT_PORT_VALUE = -1;
    private static final String UNKNOWN_HOST_NAME = "Unknown";
    private static final String EXECUTE_METHOD_NAME = "execute";
    private static final String EXECUTE_METHOD_DESC = "(Lorg/apache/commons/httpclient/HttpState;Lorg/apache/commons/httpclient/HttpConnection;)I";
    private static final String GET_RESPONSE_BODY_NAME = "getResponseBody";
    private static final String GET_RESPONSE_BODY_DESC_1 = "()[B";
    private static final String GET_RESPONSE_BODY_DESC_2 = "(I)[B";
    private static final String RELEASE_CONNECTION_NAME = "releaseConnection";
    private static final String RELEASE_CONNECTION_DESC = "()V";
    protected static final String HTTP_METHOD_BASE_CLASS_NAME_MATCH = "com/newrelic/agent/deps/org/apache/commons/httpclient/HttpMethodBase";
    private final MethodCache getHostMethodCache = ServiceFactory.getCacheService().getMethodCache("com/newrelic/agent/deps/org/apache/commons/httpclient/HttpConnection", "getHost", "()V");
    private final MethodCache getPortMethodCache = ServiceFactory.getCacheService().getMethodCache("com/newrelic/agent/deps/org/apache/commons/httpclient/HttpConnection", "getPort", "()I");
    private final MethodCache getProtocolMethodCache = ServiceFactory.getCacheService().getMethodCache("com/newrelic/agent/deps/org/apache/commons/httpclient/HttpConnection", "getProtocol", "()Lorg/apache/commons/httpclient/protocol/Protocol;");

    public HttpMethodBasePointCut(ClassTransformer classTransformer) {
        super((Class<? extends HttpCommonsPointCut>)HttpMethodBasePointCut.class, (ClassMatcher)new ExactClassMatcher(HTTP_METHOD_BASE_CLASS_NAME_MATCH), OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(EXECUTE_METHOD_NAME, EXECUTE_METHOD_DESC), new ExactMethodMatcher(GET_RESPONSE_BODY_NAME, GET_RESPONSE_BODY_DESC_1, GET_RESPONSE_BODY_DESC_2), new ExactMethodMatcher(RELEASE_CONNECTION_NAME, "()V")));
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object httpMethod, Object[] args) {
        String host = UNKNOWN_HOST_NAME;
        String methodName = "";
        String uri = "";
        int port = -1;
        try {
            int index;
            Object header;
            if (sig.getMethodName() == EXECUTE_METHOD_NAME) {
                Object httpConnection = args[1];
                if (httpConnection != null) {
                    host = this.getHost(httpConnection);
                    port = this.getPort(httpConnection);
                    if (httpMethod != null) {
                        URI theUri = this.getUri(httpMethod);
                        String scheme = theUri.getScheme();
                        if (scheme == null) {
                            scheme = this.getScheme(httpConnection);
                            String path = theUri.getPath();
                            if ("null".equals(path)) {
                                path = null;
                            }
                            uri = InstrumentUtils.getURI(scheme, host, port, path);
                        } else {
                            uri = InstrumentUtils.getURI(theUri.getScheme(), theUri.getHost(), port, theUri.getPath());
                        }
                    }
                }
                if (httpMethod instanceof HttpMethodBase) {
                    HttpMethodBase httpMethodBase = (HttpMethodBase)httpMethod;
                    transaction.getCrossProcessState().processOutboundRequestHeaders((OutboundHeaders)new OutboundHeadersWrapper(httpMethodBase));
                }
                return super.getTracer(transaction, sig, httpMethod, host, uri, EXECUTE_METHOD_NAME);
            }
            if ((sig.getMethodName() == GET_RESPONSE_BODY_NAME || sig.getMethodName() == RELEASE_CONNECTION_NAME) && (header = ((HttpMethodExtension)httpMethod)._nr_getRequestHeader("host")) != null && (index = (host = ((NameValuePair)header).getValue()).indexOf(58)) > -1) {
                host = host.substring(0, index);
            }
            if (sig != null) {
                methodName = sig.getMethodName();
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Instrumentation error invoking {0} in {1}: {2}", sig, this.getClass().getName(), t);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, t);
            }
            Agent.LOG.finer(msg);
        }
        return new ExternalComponentTracer(transaction, sig, httpMethod, host, "CommonsHttp", uri, methodName);
    }

    private String getHost(Object httpConnection) throws Exception {
        if (httpConnection instanceof HttpConnection) {
            return ((HttpConnection)httpConnection).getHost();
        }
        Method getHost = this.getHostMethodCache.getDeclaredMethod(httpConnection.getClass());
        return (String)getHost.invoke(httpConnection, new Object[0]);
    }

    private String getScheme(Object httpConnection) throws Exception {
        Method getProtocol = this.getProtocolMethodCache.getDeclaredMethod(httpConnection.getClass());
        Object protocol = getProtocol.invoke(httpConnection, new Object[0]);
        if (protocol instanceof Protocol) {
            return ((Protocol)protocol).getScheme();
        }
        return null;
    }

    private int getPort(Object httpConnection) throws Exception {
        if (httpConnection instanceof HttpConnection) {
            return ((HttpConnection)httpConnection).getPort();
        }
        Method getPort = this.getPortMethodCache.getDeclaredMethod(httpConnection.getClass());
        Integer port = (Integer)getPort.invoke(httpConnection, new Object[0]);
        if (port == null) {
            return -1;
        }
        return port;
    }

    private URI getUri(Object httpMethod) throws Exception {
        Object uri = ((HttpMethodExtension)httpMethod)._nr_getUri();
        if (uri instanceof URI) {
            return (URI)uri;
        }
        return null;
    }

    private class OutboundHeadersWrapper
    implements OutboundHeaders {
        private final HttpMethodBase request;

        public OutboundHeadersWrapper(HttpMethodBase httpMethodBase) {
            this.request = httpMethodBase;
        }

        public void setHeader(String name, String value) {
            this.request.setRequestHeader(name, value);
        }

        public HeaderType getHeaderType() {
            return HeaderType.HTTP;
        }
    }

    @InterfaceMixin(originalClassName={"com/newrelic/agent/deps/org/apache/commons/httpclient/HttpConnection"})
    public static interface HttpConnection {
        public String getHost();

        public int getPort();
    }
}

