/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.netty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionHolder;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.container.netty.DelegatingNettyHttpResponse;
import com.newrelic.agent.instrumentation.pointcuts.container.netty.NettyHttpResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.api.agent.Response;
import java.text.MessageFormat;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class NettyCompletePointCut
extends PointCut
implements EntryInvocationHandler {
    public static final boolean DEFAULT_ENABLED = true;
    private static final String POINT_CUT_NAME = NettyCompletePointCut.class.getName();

    public NettyCompletePointCut(ClassTransformer classTransformer) {
        super(NettyCompletePointCut.createPointCutConfig(), NettyCompletePointCut.createClassMatcher(), NettyCompletePointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "netty_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("org/jboss/netty/handler/codec/http/HttpMessageEncoder");
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher("encode", "(Lorg/jboss/netty/channel/ChannelHandlerContext;Lorg/jboss/netty/channel/Channel;Ljava/lang/Object;)Ljava/lang/Object;");
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!object.getClass().getName().equals("org.jboss.netty.handler.codec.http.HttpResponseEncoder")) {
            return;
        }
        this.handleTransactionHolder(args);
    }

    void handleTransactionHolder(Object[] args) {
        if (args[1] instanceof TransactionHolder && args[2] instanceof NettyHttpResponse) {
            TransactionHolder txHolder = (TransactionHolder)args[1];
            Transaction tx = (Transaction)txHolder._nr_getTransaction();
            if (tx == null || !tx.isStarted()) {
                Agent.LOG.fine(MessageFormat.format("Unable to complete {0} held by {1}", tx, txHolder));
                return;
            }
            Response response = tx.getDispatcher().getResponse();
            if (response instanceof DelegatingNettyHttpResponse) {
                ((DelegatingNettyHttpResponse)response).setDelegate((NettyHttpResponse)args[2]);
            }
            tx.getTransactionState().asyncJobFinished(txHolder);
            tx.beforeSendResponseHeaders();
        }
    }
}

