/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.DatabaseVendor;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.database.RecordSql;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import com.newrelic.agent.instrumentation.pointcuts.database.DatabaseUtils;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultExplainPlanExecutor;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlDriverPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.StatementData;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DatabaseTracer;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.ISqlStatementTracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SqlStatementTracer
extends DefaultTracer
implements DatabaseTracer,
ISqlStatementTracer {
    public static final String EXPLAIN_PLAN_PARAMETER_NAME = "explanation";
    public static final String EXPLAIN_PLAN_FORMAT_PARAMETER_NAME = "explanation_format";
    public static final String DATABASE_VENDOR_PARAMETER_NAME = "database_vendor";
    public static final String SQL_PARAMETER_NAME = "sql";
    public static final String SQL_OBFUSCATED_PARAMETER_NAME = "sql_obfuscated";
    private static final MetricNameFormat sUnknownSQLNameFormat = new SimpleMetricNameFormat("Database/UnknownSql");
    private ParsedDatabaseStatement parsedStatement;
    private final StatementData statementData;
    private ExplainPlanExecutor explainPlanExecutor;
    private ConnectionFactory connectionFactory;
    private Object sqlObject;
    private DatabaseVendor databaseVendor;

    public SqlStatementTracer(Transaction transaction, ClassMethodSignature sig, Object statementObject, StatementData statementData) {
        super(transaction, sig, statementObject, NULL_METRIC_NAME_FORMATTER, 38);
        this.statementData = statementData;
        if (Agent.isDebugEnabled() && statementData == null) {
            Agent.LOG.finer("No sql for sql statement " + statementObject);
        }
    }

    protected void doFinish(Throwable throwable) {
        this.setDatabaseVendor();
        Object sql = this.getSqlObject();
        if (sql != null) {
            this.getTransaction().getIntrinsicAttributes().put(SQL_PARAMETER_NAME, sql);
        }
    }

    protected Object getSqlObject() {
        if (this.sqlObject != null) {
            return this.sqlObject;
        }
        return this.statementData == null ? null : this.statementData.getSql();
    }

    public Object getSql() {
        return this.getSqlObject();
    }

    protected void doFinish(int opcode, Object returnValue) {
        super.doFinish(opcode, returnValue);
        this.getTransaction().getSqlTracerListener().noticeSqlTracer(this);
        if (this.statementData != null) {
            if (this.isTransactionSegment() && this.captureSql()) {
                this.sqlObject = this.getSqlObject();
            }
            this.parsedStatement = this.statementData.getParsedStatement(returnValue, this.getTransaction().getRPMService().getConnectionTimestamp());
            this.setDatabaseVendor();
        }
        this.setMetricNameFormat(this.parsedStatement == DatabaseStatementParser.UNPARSEABLE_STATEMENT ? sUnknownSQLNameFormat : this.parsedStatement);
        if (this.isTransactionSegment() && this.statementData != null && this.statementData.getSql() != null) {
            TransactionTracerConfig transactionTracerConfig = this.getTransaction().getTransactionTracerConfig();
            double explainThresholdInNanos = transactionTracerConfig.getExplainThresholdInNanos();
            if (transactionTracerConfig.isExplainEnabled()) {
                this.captureExplain(this.parsedStatement, explainThresholdInNanos, transactionTracerConfig);
            } else if (Agent.isDebugEnabled()) {
                String msg = MessageFormat.format("Statement exceeded threshold?: {0}", (double)this.getDuration() > explainThresholdInNanos);
                Agent.LOG.finer(msg);
            }
        }
    }

    protected boolean shouldStoreStackTrace() {
        return super.shouldStoreStackTrace() && this.statementData != null && this.statementData.getSql() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDatabaseVendor() {
        try {
            try {
                Connection connection = this.statementData.getStatement().getConnection();
                this.databaseVendor = DatabaseUtils.getDatabaseVendor(connection);
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINEST, "Error getting database information", e);
                if (this.databaseVendor == null) {
                    this.databaseVendor = DatabaseVendor.UNKNOWN;
                }
                return;
            }
        }
        finally {
            if (this.databaseVendor == null) {
                this.databaseVendor = DatabaseVendor.UNKNOWN;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureExplain(ParsedDatabaseStatement parsedStatement, double explainThresholdInNanos, TransactionTracerConfig transactionTracerConfig) {
        if ((double)this.getDuration() > explainThresholdInNanos && "select".equals(parsedStatement.getOperation())) {
            if (this.getTransaction().getTransactionCounts().getExplainPlanCount() >= transactionTracerConfig.getMaxExplainPlans()) {
                return;
            }
            String sql = this.statementData.getSql();
            if (Strings.isEmpty(sql)) {
                this.setExplainPlan("Unable to run the explain plan because we have no sql");
                return;
            }
            try {
                Connection connection = this.statementData.getStatement().getConnection();
                if (connection == null) {
                    this.setExplainPlan("Unable to run the explain plan because the statement returned a null connection");
                    if (Agent.LOG.isLoggable(Level.FINER)) {
                        Agent.LOG.log(Level.FINER, "Unable to run an explain plan because the Statement.getConnection() returned null : " + this.statementData.getStatement().getClass().getName());
                    }
                    return;
                }
                if (!this.databaseVendor.isExplainPlanSupported()) {
                    this.setExplainPlan("Unable to run explain plans for " + this.databaseVendor.getName() + " databases");
                    return;
                }
                this.connectionFactory = SqlDriverPointCut.getConnectionFactory(this.getTransaction(), connection);
                if (this.connectionFactory != null) {
                    this.explainPlanExecutor = this.createExplainPlanExecutor(sql);
                    if (this.explainPlanExecutor == null) {
                    } else {
                        if (Agent.LOG.isLoggable(Level.FINEST)) {
                            Agent.LOG.finest("Capturing information for explain plan");
                        }
                        this.getTransaction().getTransactionCounts().incrementExplainPlanCountAndLogIfReachedMax(transactionTracerConfig.getMaxExplainPlans());
                    }
                } else {
                    this.setExplainPlan("Unable to create a connection to run the explain plan");
                    if (Agent.isDebugEnabled()) {
                        String msg = MessageFormat.format("Unable to run explain plan because no connection factory ({0}) was found for connection {1}, statement {2}", this.getTransaction().getConnectionCache().getConnectionFactoryCacheSize(), connection.getClass().getName(), this.statementData.getStatement().getClass().getName());
                        Agent.LOG.finer(msg);
                    }
                }
            }
            catch (SQLException e) {
                String msg = MessageFormat.format("An error occurred running the explain plan: {0}", e);
                this.setExplainPlan(msg);
                Agent.LOG.finer(msg);
            }
            finally {
                if (this.explainPlanExecutor == null) {
                    this.connectionFactory = null;
                }
            }
        }
    }

    protected RecordSql getRecordSql() {
        return RecordSql.get(this.getTransaction().getTransactionTracerConfig().getRecordSql());
    }

    protected ExplainPlanExecutor createExplainPlanExecutor(String sql) {
        return new DefaultExplainPlanExecutor(this, sql, this.getRecordSql());
    }

    private boolean captureSql() {
        return "off" != this.getTransaction().getTransactionTracerConfig().getRecordSql();
    }

    public boolean hasExplainPlan() {
        return this.getParameters().containsKey(EXPLAIN_PLAN_PARAMETER_NAME);
    }

    public void setExplainPlan(Object ... explainPlan) {
        this.setParameter(EXPLAIN_PLAN_PARAMETER_NAME, Arrays.asList(explainPlan));
        if (this.databaseVendor != DatabaseVendor.UNKNOWN) {
            this.setParameter(DATABASE_VENDOR_PARAMETER_NAME, this.databaseVendor.getType());
            this.setParameter(EXPLAIN_PLAN_FORMAT_PARAMETER_NAME, this.databaseVendor.getExplainPlanFormat());
        }
    }

    public boolean isMetricProducer() {
        return this.parsedStatement != null && this.parsedStatement.recordMetric();
    }

    protected void doRecordMetrics(TransactionStats transactionStats) {
        if (this.getMetricName() != null) {
            transactionStats.getUnscopedStats().getResponseTimeStats(this.parsedStatement.getOperationRollupMetricName()).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            transactionStats.getUnscopedStats().getResponseTimeStats("Database/all").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            transactionStats.getUnscopedStats().getResponseTimeStats(this.getTransaction().isWebTransaction() ? "Database/allWeb" : "Database/allOther").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        }
    }

    public ExplainPlanExecutor getExplainPlanExecutor() {
        return this.explainPlanExecutor;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

