/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentUtils;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.net.HttpURLConnectionTracer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.OutboundHeaders;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;

@PointCut
public class HttpURLConnectionPointCut
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = HttpURLConnectionPointCut.class.getName();
    private static final boolean DEFAULT_ENABLED = true;
    private static final boolean ONLY_MATCH_CHILDREN = false;
    private static final String CONNECT_METHOD_NAME = "connect";
    private static final String CONNECT_METHOD_DESC = "()V";
    private static final String GET_INPUT_STREAM_METHOD_NAME = "getInputStream";
    private static final String GET_INPUT_STREAM_METHOD_DESC = "()Ljava/io/InputStream;";
    private static final String GET_OUTPUT_STREAM_METHOD_NAME = "getOutputStream";
    private static final String GET_OUTPUT_STREAM_METHOD_DESC = "()Ljava/io/OutputStream;";
    private static final String GET_RESPONSE_CODE_METHOD_NAME = "getResponseCode";
    private static final String GET_RESPONSE_CODE_METHOD_DESC = "()I";
    private static final String HTTP_URL_CONNECTION_CLASS_NAME = "java/net/HttpURLConnection";
    private static final String TO_INCLUDE_CHILD = "sun/net/www/protocol/http/HttpURLConnection";

    public HttpURLConnectionPointCut(ClassTransformer classTransformer) {
        super(HttpURLConnectionPointCut.createPointCutConfig(), HttpURLConnectionPointCut.createClassMatcher(), HttpURLConnectionPointCut.createMethodMatcher());
        classTransformer.getClassNameFilter().addIncludeClass(HTTP_URL_CONNECTION_CLASS_NAME);
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ChildClassMatcher(HTTP_URL_CONNECTION_CLASS_NAME, false, new String[]{TO_INCLUDE_CHILD});
    }

    private static MethodMatcher createMethodMatcher() {
        return OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(CONNECT_METHOD_NAME, CONNECT_METHOD_DESC), new ExactMethodMatcher(GET_RESPONSE_CODE_METHOD_NAME, GET_RESPONSE_CODE_METHOD_DESC), new ExactMethodMatcher(GET_INPUT_STREAM_METHOD_NAME, GET_INPUT_STREAM_METHOD_DESC), new ExactMethodMatcher(GET_OUTPUT_STREAM_METHOD_NAME, GET_OUTPUT_STREAM_METHOD_DESC));
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
        try {
            ServiceFactory.getAgent().getInstrumentation().retransformUninstrumentedClasses(HTTP_URL_CONNECTION_CLASS_NAME.replaceAll("/", "."));
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error retransforming {0}: {1}", HTTP_URL_CONNECTION_CLASS_NAME, t);
            Agent.LOG.info(msg);
        }
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object connection, Object[] args) {
        HttpURLConnection urlConnection = (HttpURLConnection)connection;
        final URL url = urlConnection.getURL();
        String uri = InstrumentUtils.getURI(url);
        String host = url.getHost();
        String methodName = sig.getMethodName();
        boolean connected = this.isConnected(urlConnection);
        Agent.LOG.log(Level.FINEST, "HttpUrlConnection getTransaction {0}: connected : {1}, new relic header: {2}", new Object[]{sig.getMethodName(), connected, urlConnection.getRequestProperty("X-NewRelic-ID")});
        if (!connected && null == urlConnection.getRequestProperty("X-NewRelic-ID")) {
            if (GET_OUTPUT_STREAM_METHOD_NAME == sig.getMethodName()) {
                return this.getOutputStreamConnectionTracer(transaction, sig, urlConnection, uri, host, methodName);
            }
            return this.getConnectionTracer(transaction, sig, urlConnection, uri, host, methodName);
        }
        if (CONNECT_METHOD_NAME == sig.getMethodName()) {
            return null;
        }
        if (GET_OUTPUT_STREAM_METHOD_NAME == sig.getMethodName()) {
            return new MethodExitTracer(sig, transaction){

                protected void doFinish(int opcode, Object returnValue) {
                    this.getTransaction().getTransactionCache().putURL(returnValue, url);
                }
            };
        }
        return this.getResponseCodeTracer(transaction, sig, urlConnection, uri, host, methodName);
    }

    private Tracer getConnectionTracer(Transaction transaction, ClassMethodSignature sig, HttpURLConnection urlConnection, String uri, String host, String methodName) {
        if (!urlConnection.getClass().getName().contains("weblogic.net.http.SOAPHttpURLConnection")) {
            transaction.getCrossProcessState().processOutboundRequestHeaders((OutboundHeaders)new OutboundHeadersWrapper(urlConnection));
        }
        return new ExternalComponentTracer(transaction, sig, (Object)urlConnection, host, "HttpURLConnection", uri, methodName);
    }

    private Tracer getOutputStreamConnectionTracer(Transaction transaction, ClassMethodSignature sig, HttpURLConnection urlConnection, String uri, String host, String methodName) {
        final URL url = urlConnection.getURL();
        transaction.getCrossProcessState().processOutboundRequestHeaders((OutboundHeaders)new OutboundHeadersWrapper(urlConnection));
        return new ExternalComponentTracer(transaction, sig, urlConnection, host, "HttpURLConnection", uri, new String[]{methodName}){

            protected void doFinish(int opcode, Object returnValue) {
                super.doFinish(opcode, returnValue);
                this.getTransaction().getTransactionCache().putURL(returnValue, url);
            }
        };
    }

    private Tracer getResponseCodeTracer(Transaction transaction, ClassMethodSignature sig, HttpURLConnection urlConnection, String uri, String host, String methodName) {
        List<Tracer> tracers = transaction.getTransactionActivity().getTracers();
        if (tracers.size() == 0 || tracers.get(tracers.size() - 1) instanceof HttpURLConnectionTracer) {
            return null;
        }
        return new HttpURLConnectionTracer(transaction, sig, (Object)urlConnection, host, "HttpURLConnection", uri, methodName);
    }

    private boolean isConnected(HttpURLConnection connection) {
        try {
            connection.setAllowUserInteraction(connection.getAllowUserInteraction());
            return false;
        }
        catch (IllegalStateException ise) {
            return true;
        }
    }

    private class OutboundHeadersWrapper
    implements OutboundHeaders {
        private final HttpURLConnection connection;

        public OutboundHeadersWrapper(HttpURLConnection connection) {
            this.connection = connection;
        }

        public void setHeader(String name, String value) {
            this.connection.setRequestProperty(name, value);
        }

        public HeaderType getHeaderType() {
            return HeaderType.HTTP;
        }
    }
}

