/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.InstrumentUtils;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.Tracer;
import java.net.URL;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class PosterOutputStreamPointCut
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = "http_output_stream";
    private static final boolean DEFAULT_ENABLED = false;
    public static final String POSTER_OUTPUT_STREAM_CLASS_NAME = "sun/net/www/http/PosterOutputStream";
    private static final String WRITE_METHOD_NAME = "write";
    private static final String WRITE_METHOD_DESC = "([BII)V";

    public PosterOutputStreamPointCut(ClassTransformer classTransformer) {
        super(PosterOutputStreamPointCut.createPointCutConfig(), PosterOutputStreamPointCut.createClassMatcher(), PosterOutputStreamPointCut.createMethodMatcher());
        classTransformer.getClassNameFilter().addIncludeClass(POSTER_OUTPUT_STREAM_CLASS_NAME);
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, false);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(POSTER_OUTPUT_STREAM_CLASS_NAME);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(WRITE_METHOD_NAME, WRITE_METHOD_DESC);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object outputStream, Object[] args) {
        String uri;
        String host;
        URL url = transaction.getTransactionCache().getURL(outputStream);
        if (url != null) {
            host = url.getHost();
            uri = InstrumentUtils.getURI(url);
        } else {
            host = "unknown";
            uri = "";
        }
        String operation = sig != null ? sig.getMethodName() : "";
        return new HttpOutputStreamTracer(this, transaction, sig, outputStream, host, "HttpOutputStream", uri, new String[]{operation});
    }

    private static final class HttpOutputStreamTracer
    extends ExternalComponentTracer
    implements IOTracer {
        private HttpOutputStreamTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String uri, String[] operations) {
            super(transaction, sig, object, host, library, uri, operations);
        }
    }
}

