/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.play2;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.FieldAccessor;
import com.newrelic.agent.instrumentation.InterfaceMapper;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.MethodMapper;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.container.netty.DelegatingNettyHttpRequest;
import com.newrelic.agent.instrumentation.pointcuts.scala.ScalaCollectionJavaConversions;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class Play2RequestPointCut
extends PointCut
implements EntryInvocationHandler {
    private static final boolean DEFAULT_ENABLED = true;
    private static final String POINT_CUT_NAME = Play2RequestPointCut.class.getName();
    static final String PLAY21CLASS = "play/api/mvc/Request$";
    static final String REQUEST_METHOD_NAME = "apply";
    static final String REQUEST_METHOD_DESC = "(Lplay/api/mvc/RequestHeader;Ljava/lang/Object;)Lplay/api/mvc/Request;";
    static final String PLAY20CLASS = "play/core/server/Server$class";
    static final String SERVER_METHOD_NAME = "invoke";
    static final String SERVER_METHOD_DESC = "(Lplay/core/server/Server;Lplay/api/mvc/Request;Lplay/api/mvc/Response;Lplay/api/mvc/Action;Lplay/api/Application;)V";

    public Play2RequestPointCut(ClassTransformer classTransformer) {
        super(Play2RequestPointCut.createPointCutConfig(), Play2RequestPointCut.createClassMatcher(), Play2RequestPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "play2_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return OrClassMatcher.getClassMatcher(new ExactClassMatcher(PLAY21CLASS), new ExactClassMatcher(PLAY20CLASS));
    }

    private static MethodMatcher createMethodMatcher() {
        return OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(REQUEST_METHOD_NAME, REQUEST_METHOD_DESC), new ExactMethodMatcher(SERVER_METHOD_NAME, SERVER_METHOD_DESC));
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!Transaction.hasTransaction() || !Transaction.getTransaction().isStarted()) {
            return;
        }
        Transaction tx = Transaction.getTransaction();
        com.newrelic.api.agent.Request request = tx.getRootTransaction().getDispatcher().getRequest();
        HashMap<String, List<Object>> extractedForm = new HashMap<String, List<Object>>();
        if (request instanceof DelegatingNettyHttpRequest) {
            AnyContentAsFormUrlEncoded formBody;
            RequestHeader rh;
            List values;
            Map formValues;
            Object data;
            DelegatingNettyHttpRequest nettyRequest = (DelegatingNettyHttpRequest)request;
            Object bodyCandidate = args[1];
            if (args[1] instanceof Request) {
                Request req = (Request)args[1];
                bodyCandidate = req.nr_body();
                data = req.nr_queryString();
                if (data != null) {
                    formValues = ScalaCollectionJavaConversions.asJavaMap(data);
                    for (Map.Entry formValue : formValues.entrySet()) {
                        values = ScalaCollectionJavaConversions.asJavaList(formValue.getValue());
                        extractedForm.put((String)formValue.getKey(), new ArrayList(values));
                    }
                }
            } else if (args[0] instanceof RequestHeader && (data = (rh = (RequestHeader)args[0]).nr_queryString()) != null) {
                formValues = ScalaCollectionJavaConversions.asJavaMap(data);
                for (Map.Entry formValue : formValues.entrySet()) {
                    values = ScalaCollectionJavaConversions.asJavaList(formValue.getValue());
                    extractedForm.put((String)formValue.getKey(), new ArrayList(values));
                }
            }
            if (bodyCandidate instanceof AnyContentAsFormUrlEncoded && (data = (formBody = (AnyContentAsFormUrlEncoded)bodyCandidate).nr_data()) != null) {
                formValues = ScalaCollectionJavaConversions.asJavaMap(data);
                for (Map.Entry formValue : formValues.entrySet()) {
                    values = ScalaCollectionJavaConversions.asJavaList(formValue.getValue());
                    if (extractedForm.containsKey(formValue.getKey())) {
                        ((List)extractedForm.get(formValue.getKey())).addAll(values);
                        continue;
                    }
                    extractedForm.put((String)formValue.getKey(), new ArrayList(values));
                }
            }
            nettyRequest.setParameters(extractedForm);
        }
    }

    @InterfaceMixin(originalClassName={"play/api/mvc/AnyContentAsFormUrlEncoded"})
    public static interface AnyContentAsFormUrlEncoded {
        public static final String CLASS = "play/api/mvc/AnyContentAsFormUrlEncoded";

        @FieldAccessor(fieldName="data", existingField=true, fieldDesc="Lscala/collection/immutable/Map;")
        public Object nr_data();
    }

    @InterfaceMapper(originalInterfaceName="play/api/mvc/RequestHeader", className={"play/api/mvc/RequestHeader$$anon$4"})
    public static interface RequestHeader {
        public static final String INTERFACE = "play/api/mvc/RequestHeader";
        public static final String CLASS = "play/api/mvc/RequestHeader$$anon$4";

        @MethodMapper(originalMethodName="queryString", originalDescriptor="()Lscala/collection/immutable/Map;")
        public Object nr_queryString();
    }

    @InterfaceMapper(originalInterfaceName="play/api/mvc/Request", className={"play/core/server/netty/PlayDefaultUpstreamHandler$$anonfun$19$$anonfun$apply$21$$anon$1"})
    public static interface Request {
        public static final String INTERFACE = "play/api/mvc/Request";
        public static final String CLASS = "play/core/server/netty/PlayDefaultUpstreamHandler$$anonfun$19$$anonfun$apply$21$$anon$1";

        @MethodMapper(originalMethodName="body")
        public Object nr_body();

        @MethodMapper(originalMethodName="queryString", originalDescriptor="()Lscala/collection/immutable/Map;")
        public Object nr_queryString();
    }
}

