/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.play2;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.play2.HandlerDef;
import com.newrelic.agent.instrumentation.pointcuts.play2.TaggingInvoker;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import java.text.MessageFormat;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class TaggingInvokerPointCut
extends PointCut
implements EntryInvocationHandler {
    private static final boolean DEFAULT_ENABLED = true;
    private static final String POINT_CUT_NAME = TaggingInvokerPointCut.class.getName();
    public static final String CLASS_NAME = "play/core/Router$Routes$TaggingInvoker";
    private static final String METHOD_NAME = "call";
    private static final String METHOD_DESC = "(Lscala/Function0;)Lplay/api/mvc/Handler;";

    public TaggingInvokerPointCut(ClassTransformer classTransformer) {
        super(TaggingInvokerPointCut.createPointCutConfig(), TaggingInvokerPointCut.createClassMatcher(), TaggingInvokerPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "play2_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(CLASS_NAME);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(METHOD_NAME, METHOD_DESC);
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        TaggingInvoker taggingInvoker;
        Object handlerDef;
        if (!Transaction.hasTransaction() || !Transaction.getTransaction().isStarted()) {
            return;
        }
        Transaction tx = Transaction.getTransaction();
        if (object instanceof TaggingInvoker && (handlerDef = (taggingInvoker = (TaggingInvoker)object).getHandlerDef()) instanceof HandlerDef) {
            this.setTransactionName(tx, (HandlerDef)handlerDef);
        }
    }

    private void setTransactionName(Transaction tx, HandlerDef handlerDef) {
        String action = MessageFormat.format("{0}.{1}", handlerDef.controller(), handlerDef.method());
        this.setTransactionName(tx, action);
    }

    private void setTransactionName(Transaction tx, String controllerAction) {
        if (!tx.isTransactionNamingEnabled()) {
            return;
        }
        TransactionNamingPolicy policy = TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(tx, TransactionNamePriority.FRAMEWORK_LOW)) {
            String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Play 2.3 controller action", controllerAction);
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(tx, controllerAction, "PlayControllerAction", TransactionNamePriority.FRAMEWORK_LOW);
    }
}

