/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.spring;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.TraceDetailsList;
import com.newrelic.agent.instrumentation.tracing.InstrumentationType;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import java.util.Set;
import java.util.logging.Level;

public class SpringAnnotationVisitor {
    private static final Set<String> CONTROLLER_DESCRIPTORS = ImmutableSet.of(Type.getObjectType("org/springframework/stereotype/Controller").getDescriptor(), Type.getObjectType("org/springframework/web/bind/annotation/RestController").getDescriptor());
    private static final String REQUEST_MAPPING_DESCRIPTOR = Type.getObjectType("org/springframework/web/bind/annotation/RequestMapping").getDescriptor();

    public final ClassMatchVisitorFactory getClassMatchVisitorFactory() {
        return new ClassMatchVisitorFactory(){

            @Override
            public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
                return SpringAnnotationVisitor.createClassVisitor(reader.getClassName(), cv, context);
            }
        };
    }

    public static ClassVisitor createClassVisitor(final String internalClassName, ClassVisitor cv, final TraceDetailsList context) {
        return new ClassVisitor(327680, cv){
            private boolean isController;
            private String rootPath;
            {
                super(x0, x1);
                this.isController = false;
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (CONTROLLER_DESCRIPTORS.contains(desc)) {
                    this.isController = true;
                }
                if (REQUEST_MAPPING_DESCRIPTOR.equals(desc)) {
                    av = new AnnotationVisitor(327680, av){

                        public AnnotationVisitor visitArray(String name) {
                            AnnotationVisitor av = super.visitArray(name);
                            if ("value".equals(name)) {
                                return new AnnotationVisitor(327680, av){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        rootPath = value.toString();
                                    }
                                };
                            }
                            return av;
                        }
                    };
                }
                return av;
            }

            public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                if (!this.isController) {
                    return super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                }
                return new MethodVisitor(327680, super.visitMethod(access, methodName, methodDesc, signature, exceptions)){
                    String path;
                    String httpMethod;
                    {
                        super(x0, x1);
                        this.httpMethod = "GET";
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (REQUEST_MAPPING_DESCRIPTOR.equals(desc)) {
                            return new AnnotationVisitor(327680, super.visitAnnotation(desc, visible)){

                                public AnnotationVisitor visitArray(String name) {
                                    AnnotationVisitor av = super.visitArray(name);
                                    if ("value".equals(name)) {
                                        return new AnnotationVisitor(327680, av){

                                            public void visit(String name, Object value) {
                                                super.visit(name, value);
                                                path = value.toString();
                                            }
                                        };
                                    }
                                    if ("method".equals(name)) {
                                        return new AnnotationVisitor(327680, av){

                                            public void visitEnum(String name, String desc, String value) {
                                                super.visitEnum(name, desc, value);
                                                httpMethod = value;
                                            }
                                        };
                                    }
                                    return av;
                                }

                                public void visitEnd() {
                                    super.visitEnd();
                                    if (path == null && rootPath == null) {
                                        Agent.LOG.log(Level.FINE, "No path was specified for SpringController {0}", new Object[]{internalClassName});
                                    } else {
                                        TraceDetailsBuilder builder = TraceDetailsBuilder.newBuilder().setInstrumentationType(InstrumentationType.BuiltIn).setInstrumentationSourceName(SpringAnnotationVisitor.class.getName()).setDispatcher(true);
                                        String fullPath = SpringAnnotationVisitor.getPath(rootPath, path, httpMethod);
                                        builder.setTransactionName(TransactionNamePriority.FRAMEWORK_HIGH, true, "SpringController", fullPath);
                                        context.addTrace(new Method(methodName, methodDesc), builder.build());
                                    }
                                }
                            };
                        }
                        return super.visitAnnotation(desc, visible);
                    }
                };
            }
        };
    }

    static String getPath(String rootPath, String methodPath, String httpMethod) {
        StringBuilder fullPath = new StringBuilder();
        if (rootPath != null) {
            if (rootPath.endsWith("/")) {
                fullPath.append(rootPath.substring(0, rootPath.length() - 1));
            } else {
                fullPath.append(rootPath);
            }
        }
        if (methodPath != null) {
            if (!methodPath.startsWith("/")) {
                fullPath.append('/');
            }
            if (methodPath.endsWith("/")) {
                fullPath.append(methodPath.substring(0, methodPath.length() - 1));
            } else {
                fullPath.append(methodPath);
            }
        }
        fullPath.append(" (").append(httpMethod).append(')');
        return fullPath.toString();
    }
}

