/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.JarUtils;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.bootstrap.BootstrapAgent;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ClassAppender {
    ClassAppender() {
    }

    public abstract void appendClasses(ClassLoader var1, Map<String, byte[]> var2) throws IOException;

    public static ClassAppender getBootstrapClassAppender(final Instrumentation instrumentation) {
        return new ClassAppender(){

            @Override
            public void appendClasses(ClassLoader loader, Map<String, byte[]> classBytes) throws IOException {
                instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(JarUtils.createJarFile("instrumentation", classBytes)));
            }
        };
    }

    public static ClassAppender getSystemClassAppender() {
        Method defineClassMethod;
        try {
            defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            defineClassMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return new ClassAppender(){

            @Override
            public void appendClasses(ClassLoader loader, Map<String, byte[]> classBytes) throws IOException {
                ArrayList<ClassDefinition> existingClasses = Lists.newArrayList();
                ProtectionDomain protectionDomain = BootstrapAgent.class.getProtectionDomain();
                for (Map.Entry<String, byte[]> entry : classBytes.entrySet()) {
                    try {
                        defineClassMethod.invoke((Object)loader, entry.getKey().replace('/', '.'), entry.getValue(), 0, entry.getValue().length, protectionDomain);
                    }
                    catch (Exception e) {
                        if (Agent.isDebugEnabled()) {
                            Utils.print(entry.getValue());
                        }
                        if (e.getCause() instanceof LinkageError) {
                            String errorMessage = e.getCause().getMessage();
                            if (errorMessage == null || !errorMessage.contains("attempted  duplicate class definition")) break;
                            try {
                                Class<?> theClass = loader.loadClass(Type.getObjectType(entry.getKey()).getClassName());
                                existingClasses.add(new ClassDefinition(theClass, entry.getValue()));
                            }
                            catch (ClassNotFoundException e1) {
                                Agent.LOG.log(Level.FINEST, e1, e1.getMessage(), new Object[0]);
                            }
                            break;
                        }
                        throw new IOException(e);
                    }
                }
                if (!existingClasses.isEmpty() && ServiceFactory.getAgent().getInstrumentation().isRedefineClassesSupported()) {
                    try {
                        ServiceFactory.getAgent().getInstrumentation().redefineClasses(existingClasses.toArray(new ClassDefinition[0]));
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            }
        };
    }
}

