/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AnalyzerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LabelNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.VarInsnNode;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.weaver.IllegalInstructionException;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.instrumentation.weaver.WeaveUtils;
import com.newrelic.agent.util.asm.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MergeMethodVisitor
extends MethodNode {
    private static final Method NOTICE_INSTRUMENTATION_ERROR_METHOD = new Method("noticeInstrumentationError", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class), Type.getType(String.class)});
    private final Method method;
    private final String className;
    private int nextLocalIndex;
    private MethodInsnNode invokeOriginalNode;
    protected final int firstLocal;
    private final InstrumentationPackage instrumentationPackage;

    public MergeMethodVisitor(InstrumentationPackage instrumentationPackage, String className, int api, int access, String name, String desc, String signature, String[] exceptions) {
        super(api, access, name, desc, signature, exceptions);
        this.instrumentationPackage = instrumentationPackage;
        this.method = new Method(name, desc);
        this.className = className;
        Type[] args = Type.getArgumentTypes(desc);
        int nextLocal = (8 & access) == 0 ? 1 : 0;
        for (int i = 0; i < args.length; ++i) {
            nextLocal += args[i].getSize();
        }
        this.firstLocal = nextLocal;
    }

    @Override
    public void visitEnd() {
        try {
            int newIndex = this.determineIfNew();
            if (this.invokeOriginalNode != null) {
                boolean isStatic;
                boolean isVoid = this.method.getReturnType().equals(Type.VOID_TYPE);
                Label startOfOriginalMethod = new Label();
                Label endOfOriginalMethod = new Label();
                AbstractInsnNode insertPoint = newIndex >= 0 ? this.instructions.get(newIndex) : this.invokeOriginalNode;
                boolean callsThrow = this.isThrowCalled();
                int rethrowExceptionIndex = -1;
                int returnLocalIndex = -1;
                if (!isVoid || callsThrow) {
                    Label startOfMethod = new Label();
                    Label endOfMethod = new Label();
                    this.instructions.insert(this.getLabelNode(startOfMethod));
                    this.instructions.add(this.getLabelNode(endOfMethod));
                    if (callsThrow) {
                        rethrowExceptionIndex = this.nextLocalIndex;
                        this.visitLocalVariable("rethrowException", Type.getDescriptor(Throwable.class), null, startOfMethod, endOfMethod, rethrowExceptionIndex);
                    }
                    if (!isVoid) {
                        returnLocalIndex = this.nextLocalIndex;
                        this.visitLocalVariable("originalReturnValue", this.method.getReturnType().getDescriptor(), null, startOfMethod, endOfMethod, returnLocalIndex);
                    }
                }
                if (rethrowExceptionIndex >= 0) {
                    this.storeExceptionAtThrowSites(rethrowExceptionIndex);
                }
                LabelNode startOfOriginalMethodLabelNode = this.getLabelNode(startOfOriginalMethod);
                this.instructions.insertBefore(insertPoint, startOfOriginalMethodLabelNode);
                boolean bl = isStatic = (this.access & 8) != 0;
                if (!isStatic) {
                    this.instructions.insertBefore(insertPoint, new VarInsnNode(25, 0));
                }
                int index = isStatic ? 0 : 1;
                for (int i = 0; i < this.method.getArgumentTypes().length; ++i) {
                    this.instructions.insertBefore(insertPoint, new VarInsnNode(this.method.getArgumentTypes()[i].getOpcode(21), index));
                    ++index;
                }
                this.instructions.insertBefore(insertPoint, new MethodInsnNode(isStatic ? 184 : 182, this.className, this.method.getName(), this.method.getDescriptor()));
                if (returnLocalIndex >= 0) {
                    this.instructions.insertBefore(insertPoint, new VarInsnNode(this.method.getReturnType().getOpcode(54), returnLocalIndex));
                }
                this.instructions.insertBefore(insertPoint, this.getLabelNode(endOfOriginalMethod));
                if (returnLocalIndex >= 0) {
                    AbstractInsnNode loadInsertPoint = newIndex >= 0 ? this.invokeOriginalNode : insertPoint;
                    this.instructions.insertBefore(loadInsertPoint, new VarInsnNode(this.method.getReturnType().getOpcode(21), returnLocalIndex));
                }
                if (returnLocalIndex < 0) {
                    AbstractInsnNode popInstruction = this.invokeOriginalNode.getNext();
                    if (popInstruction.getOpcode() == 87) {
                        this.instructions.remove(popInstruction);
                    } else {
                        this.instrumentationPackage.getLogger().severe("Unexpected instruction " + popInstruction.getOpcode() + ", Method: " + this.className + '.' + this.method + ", expected " + 87);
                    }
                } else if (this.method.getReturnType().getSort() == 10 || this.method.getReturnType().getSort() == 9) {
                    AbstractInsnNode nextInstruction;
                    if (!Type.getType(Object.class).equals(this.method.getReturnType()) && (nextInstruction = this.invokeOriginalNode.getNext()).getOpcode() != 87 && nextInstruction.getOpcode() != 176) {
                        this.expectCastOrInvokeWithObject(nextInstruction);
                    }
                } else {
                    AbstractInsnNode nextInstruction = this.invokeOriginalNode.getNext();
                    if (nextInstruction.getOpcode() == 87) {
                        if (this.method.getReturnType().getSize() == 2) {
                            this.instructions.insertBefore(nextInstruction, new InsnNode(88));
                            this.instructions.remove(nextInstruction);
                        }
                    } else {
                        if (nextInstruction.getOpcode() == 192) {
                            this.instructions.remove(nextInstruction);
                        } else {
                            this.expectCastOrInvokeWithObject(nextInstruction);
                        }
                        AbstractInsnNode invokeVirtualInstruction = this.invokeOriginalNode.getNext();
                        if (invokeVirtualInstruction.getOpcode() == 182) {
                            this.instructions.remove(invokeVirtualInstruction);
                        } else {
                            this.instrumentationPackage.getLogger().severe("Unexpected instruction " + nextInstruction.getOpcode() + ", Method: " + this.className + '.' + this.method + ", expected " + 182);
                        }
                    }
                }
                this.instructions.remove(this.invokeOriginalNode);
                Label afterOriginalMethodExceptionHandler = new Label();
                this.visitLabel(afterOriginalMethodExceptionHandler);
                GeneratorAdapter generator = new GeneratorAdapter(this.access, this.method, (MethodVisitor)this);
                if (rethrowExceptionIndex >= 0) {
                    Label afterThrow = new Label();
                    generator.dup();
                    this.visitVarInsn(25, rethrowExceptionIndex);
                    this.visitJumpInsn(166, afterThrow);
                    this.visitInsn(191);
                    this.visitLabel(afterThrow);
                }
                this.noticeInstrumentationErrorInstructions(generator);
                if (returnLocalIndex >= 0) {
                    this.visitVarInsn(this.method.getReturnType().getOpcode(21), returnLocalIndex);
                }
                this.visitInsn(this.method.getReturnType().getOpcode(172));
                this.visitTryCatchBlock(endOfOriginalMethod, afterOriginalMethodExceptionHandler, afterOriginalMethodExceptionHandler, Type.getInternalName(Throwable.class));
                Label start = new Label();
                this.instructions.insert(this.getLabelNode(start));
                this.initializePreambleLocals(startOfOriginalMethodLabelNode);
                MethodNode preambleHandler = new MethodNode(327680);
                Label beforeOriginalMethodExceptionHandler = new Label();
                generator = new GeneratorAdapter(this.access, this.method, (MethodVisitor)preambleHandler);
                generator.goTo(startOfOriginalMethod);
                generator.visitLabel(beforeOriginalMethodExceptionHandler);
                this.noticeInstrumentationErrorInstructions(generator);
                this.instructions.insertBefore((AbstractInsnNode)startOfOriginalMethodLabelNode, preambleHandler.instructions);
                this.visitTryCatchBlock(start, startOfOriginalMethod, beforeOriginalMethodExceptionHandler, Type.getInternalName(Throwable.class));
            }
        }
        catch (IllegalInstructionException t) {
            this.instrumentationPackage.getLogger().severe("Unable to process method " + this.method);
            throw t;
        }
        catch (Exception e) {
            this.instrumentationPackage.getLogger().severe("Unable to process method " + this.method);
            throw new RuntimeException(e);
        }
    }

    private void storeExceptionAtThrowSites(int rethrowExceptionIndex) {
        for (AbstractInsnNode insnNode : this.instructions.toArray()) {
            if (191 != insnNode.getOpcode()) continue;
            this.instructions.insertBefore(insnNode, new VarInsnNode(58, rethrowExceptionIndex));
            this.instructions.insertBefore(insnNode, new VarInsnNode(25, rethrowExceptionIndex));
        }
    }

    private boolean isThrowCalled() {
        for (AbstractInsnNode insnNode : this.instructions.toArray()) {
            if (191 != insnNode.getOpcode()) continue;
            return true;
        }
        return false;
    }

    private void expectCastOrInvokeWithObject(AbstractInsnNode nextInstruction) {
        if (nextInstruction.getOpcode() == 192) {
            this.instructions.remove(nextInstruction);
        } else if (nextInstruction instanceof MethodInsnNode) {
            MethodInsnNode methodNode = (MethodInsnNode)nextInstruction;
            Type type = Type.getType(methodNode.desc);
            if (type.getArgumentTypes().length <= 0 || !Type.getType(Object.class).equals(type.getArgumentTypes()[0])) {
                this.instrumentationPackage.getLogger().severe("Unexpected instruction " + nextInstruction.getOpcode() + ", Method: " + methodNode.owner + '.' + methodNode.name + methodNode.desc);
            }
        } else {
            this.instrumentationPackage.getLogger().severe("Unexpected instruction " + nextInstruction.getOpcode());
        }
    }

    private void initializePreambleLocals(LabelNode startOfOriginalMethodLabelNode) {
        List<LocalVariableNode> localsInPreamble = this.getLocalsInPreamble(startOfOriginalMethodLabelNode);
        if (!localsInPreamble.isEmpty()) {
            int firstLocalIndex = Utils.getFirstLocal(this.access, this.method);
            LabelNode localsStart = this.getLabelNode(new Label());
            this.instructions.insert(localsStart);
            for (LocalVariableNode local : localsInPreamble) {
                if (local.index < firstLocalIndex) continue;
                Type type = Type.getType(local.desc);
                local.start = localsStart;
                AbstractInsnNode initialValue = this.getInitialValueInstruction(type);
                if (initialValue == null) continue;
                this.instructions.insert((AbstractInsnNode)localsStart, new VarInsnNode(type.getOpcode(54), local.index));
                this.instructions.insert((AbstractInsnNode)localsStart, initialValue);
            }
        }
    }

    private AbstractInsnNode getInitialValueInstruction(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return new InsnNode(1);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new InsnNode(3);
            }
            case 7: {
                return new InsnNode(9);
            }
            case 6: {
                return new InsnNode(11);
            }
            case 8: {
                return new InsnNode(14);
            }
        }
        return null;
    }

    private List<LocalVariableNode> getLocalsInPreamble(AbstractInsnNode insertPoint) {
        int endIndex = this.instructions.indexOf(insertPoint);
        if (endIndex < 0) {
            return Collections.emptyList();
        }
        ArrayList<LocalVariableNode> locals = Lists.newArrayList();
        for (LocalVariableNode local : this.localVariables) {
            int startIndex = this.instructions.indexOf(local.start);
            int end = this.instructions.indexOf(local.end);
            if (startIndex >= endIndex || end <= endIndex) continue;
            locals.add(local);
        }
        return locals;
    }

    private void noticeInstrumentationErrorInstructions(GeneratorAdapter generator) {
        generator.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
        generator.swap();
        generator.push(this.instrumentationPackage.implementationTitle);
        generator.invokeInterface(BridgeUtils.INSTRUMENTATION_TYPE, NOTICE_INSTRUMENTATION_ERROR_METHOD);
    }

    private int determineIfNew() {
        AnalyzerAdapter stackAnalyzer = new AnalyzerAdapter(this.className, this.access, this.name, this.desc, new MethodVisitor(327680){});
        boolean callsThrow = false;
        int lastStackZeroIndex = 0;
        AbstractInsnNode[] inst = this.instructions.toArray();
        for (int i = 0; i < inst.length; ++i) {
            int stackSize;
            int n = stackSize = stackAnalyzer.stack == null ? 0 : stackAnalyzer.stack.size();
            if (stackSize == 0) {
                lastStackZeroIndex = i;
            }
            inst[i].accept(stackAnalyzer);
            if (inst[i].getOpcode() == 191) {
                callsThrow = true;
            }
            if (!(inst[i] instanceof MethodInsnNode)) continue;
            MethodInsnNode invoke = (MethodInsnNode)inst[i];
            if (!MergeMethodVisitor.isOriginalMethodInvocation(invoke.owner, invoke.name, invoke.desc)) continue;
            if (callsThrow) {
                throw new IllegalInstructionException(this.className + '.' + this.name + this.desc + " can only throw an exception from the original method invocation");
            }
            this.invokeOriginalNode = invoke;
            if (stackSize > 0) {
                return lastStackZeroIndex;
            }
            return -1;
        }
        return -1;
    }

    public static boolean isInitMethod(String name) {
        return "<init>".equals(name);
    }

    public boolean isNewMethod() {
        return this.invokeOriginalNode == null && !MergeMethodVisitor.isInitMethod(this.name);
    }

    public String getClassName() {
        return this.className;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
        if (index >= this.nextLocalIndex) {
            this.nextLocalIndex = index + Type.getType(desc).getSize();
        }
    }

    public static boolean isOriginalMethodInvocation(String owner, String name, String desc) {
        return owner.equals(BridgeUtils.WEAVER_TYPE.getInternalName()) && name.equals(WeaveUtils.CALL_ORIGINAL_METHOD.getName()) && desc.equals(WeaveUtils.CALL_ORIGINAL_METHOD.getDescriptor());
    }
}

