/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.weaver.ClassWeaver;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.instrumentation.weaver.MixinClassVisitor;
import com.newrelic.agent.instrumentation.weaver.SkipTransformException;
import com.newrelic.agent.instrumentation.weaver.Verifier;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.asm.ClassStructure;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.api.agent.weaver.Weave;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeavingClassTransformer
implements ContextClassTransformer {
    protected final InstrumentationPackage instrumentationPackage;

    protected WeavingClassTransformer(InstrumentationPackage instrumentationPackage) {
        this.instrumentationPackage = instrumentationPackage;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        try {
            return this.doTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, match);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.SEVERE, "Unable to transform class " + className + ".  Error: " + t.toString());
            Agent.LOG.log(Level.FINE, t.toString(), t);
            return null;
        }
    }

    protected byte[] doTransform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws Exception {
        String classMatch = this.instrumentationPackage.getClassMatch(match);
        if (classMatch == null) {
            return null;
        }
        Verifier verifier = this.instrumentationPackage.getVerifier();
        if (!verifier.isEnabled(loader)) {
            return null;
        }
        MixinClassVisitor mixinClassVisitor = this.instrumentationPackage.getMixinClassVisitor(className, classMatch);
        if (null != mixinClassVisitor) {
            if (!verifier.isVerified(loader) && !verifier.verify(this.instrumentationPackage.getClassAppender(), loader, this.instrumentationPackage.getClassBytes())) {
                return null;
            }
            try {
                ClassWriter writer;
                ClassReader reader = new ClassReader(classfileBuffer);
                if ((reader.getAccess() & 0x200) != 0) {
                    if (!MatchType.Interface.equals((Object)mixinClassVisitor.getMatchType())) {
                        this.instrumentationPackage.getLogger().severe(className + " is an interface, but it is not marked with the " + Weave.class.getSimpleName() + " annotation of type Interface");
                    }
                    return null;
                }
                if (this.instrumentationPackage.getLogger().isFinerEnabled()) {
                    this.instrumentationPackage.getLogger().finer("Modifying " + className + " methods " + mixinClassVisitor.getMethods().keySet());
                }
                context.addClassResolver(this.instrumentationPackage);
                ClassVisitor cv = writer = this.instrumentationPackage.getClassWriter(2, loader);
                ClassStructure classStructure = ClassStructure.getClassStructure(new ClassReader(context.getOriginalClassBytes()), 15);
                ClassWeaver classWeaver = new ClassWeaver(cv, mixinClassVisitor, className, verifier, classStructure, context, this.instrumentationPackage, match);
                cv = classWeaver;
                if (mixinClassVisitor.interfaces.length > 0) {
                    ArrayList<String> interfaces = Lists.newArrayList(mixinClassVisitor.interfaces);
                    interfaces.remove(BridgeUtils.WEAVER_TYPE.getInternalName());
                    this.removeExistingInterfaces(this.instrumentationPackage, loader, reader, interfaces);
                    if (!interfaces.isEmpty()) {
                        this.instrumentationPackage.getLogger().severe(this.instrumentationPackage.getImplementationTitle() + " error.  " + className + " cannot add interfaces " + interfaces);
                        return null;
                    }
                }
                reader.accept(cv, 4);
                StatsService statsService = ServiceFactory.getStatsService();
                statsService.doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format("Supportability/WeaveInstrumentation/WeaveClass/{0}/{1}", this.instrumentationPackage.getImplementationTitle(), className), 1.0f));
                return writer.toByteArray();
            }
            catch (SkipTransformException e) {
                this.instrumentationPackage.getLogger().severe(e.getMessage());
                this.instrumentationPackage.getLogger().log(Level.FINE, "Skip transform", e);
            }
            catch (Throwable t) {
                this.instrumentationPackage.getLogger().severe("Unable to transform " + className + ".  " + t.getMessage());
                this.instrumentationPackage.getLogger().log(Level.FINE, t.getMessage(), t);
            }
        }
        return null;
    }

    private void removeExistingInterfaces(InstrumentationPackage instrumentationPackage, ClassLoader loader, ClassReader reader, List<String> interfaces) {
        if (reader == null) {
            return;
        }
        interfaces.removeAll(Arrays.asList(reader.getInterfaces()));
        for (String interfaceName : reader.getInterfaces()) {
            try {
                this.removeExistingInterfaces(instrumentationPackage, loader, Utils.readClass(loader, interfaceName), interfaces);
            }
            catch (IOException e) {
                instrumentationPackage.getLogger().log(Level.FINER, "Unable to remove interface " + interfaceName + " from " + reader.getClassName(), e);
            }
        }
        if (!"java/lang/Object".equals(reader.getSuperName())) {
            try {
                this.removeExistingInterfaces(instrumentationPackage, loader, Utils.readClass(loader, reader.getSuperName()), interfaces);
            }
            catch (IOException e) {
                instrumentationPackage.getLogger().log(Level.FINER, "Unable to remove super class " + reader.getSuperName() + " from " + reader.getClassName(), e);
            }
        }
    }

    public String toString() {
        return this.instrumentationPackage.getImplementationTitle();
    }
}

