/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseMBean
extends StandardMBean {
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getName());

    protected BaseMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    protected String getResourceString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            String msg = MessageFormat.format("Resource file {0} error: {1}", this.getClass().getName() + ".properties", ex.toString());
            Agent.LOG.finest(msg);
            throw ex;
        }
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return this.getResourceString("description");
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        try {
            return this.getResourceString("attribute." + info.getName() + ".description");
        }
        catch (Exception ex) {
            return super.getDescription(info);
        }
    }

    @Override
    protected String getDescription(MBeanFeatureInfo info) {
        try {
            return this.getResourceString("feature." + info.getName() + ".description");
        }
        catch (Exception ex) {
            return super.getDescription(info);
        }
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        try {
            return this.getResourceString("operation." + op.getName() + '.' + param.getName() + '.' + sequence + ".description");
        }
        catch (Exception ex) {
            return super.getDescription(op, param, sequence);
        }
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        try {
            return this.getResourceString("operation." + info.getName() + ".description");
        }
        catch (Exception ex) {
            return super.getDescription(info);
        }
    }
}

