/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.deps.ch.qos.logback.classic.Level;
import com.newrelic.agent.deps.org.slf4j.Marker;
import com.newrelic.agent.logging.LogbackMarkers;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LogbackLevel
extends Enum<LogbackLevel> {
    public static final /* enum */ LogbackLevel OFF;
    public static final /* enum */ LogbackLevel ALL;
    public static final /* enum */ LogbackLevel FATAL;
    public static final /* enum */ LogbackLevel SEVERE;
    public static final /* enum */ LogbackLevel ERROR;
    public static final /* enum */ LogbackLevel WARN;
    public static final /* enum */ LogbackLevel WARNING;
    public static final /* enum */ LogbackLevel INFO;
    public static final /* enum */ LogbackLevel CONFIG;
    public static final /* enum */ LogbackLevel FINE;
    public static final /* enum */ LogbackLevel FINER;
    public static final /* enum */ LogbackLevel FINEST;
    public static final /* enum */ LogbackLevel DEBUG;
    public static final /* enum */ LogbackLevel TRACE;
    private final String name;
    private final Level logbackLevel;
    private final java.util.logging.Level javaLevel;
    private final Marker marker;
    private static final Map<String, LogbackLevel> CONVERSION;
    private static final Map<java.util.logging.Level, LogbackLevel> JAVA_TO_LOGBACK;
    private static final /* synthetic */ LogbackLevel[] $VALUES;

    public static LogbackLevel[] values() {
        return (LogbackLevel[])$VALUES.clone();
    }

    public static LogbackLevel valueOf(String name) {
        return Enum.valueOf(LogbackLevel.class, name);
    }

    private LogbackLevel(String pName, Level pLogbackLevel, java.util.logging.Level pJavaLevel, Marker pMarker) {
        this.name = pName;
        this.logbackLevel = pLogbackLevel;
        this.javaLevel = pJavaLevel;
        this.marker = pMarker;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public Level getLogbackLevel() {
        return this.logbackLevel;
    }

    public java.util.logging.Level getJavaLevel() {
        return this.javaLevel;
    }

    public static LogbackLevel getLevel(String pName, LogbackLevel pDefault) {
        LogbackLevel level = CONVERSION.get(pName);
        return level == null ? pDefault : level;
    }

    public static LogbackLevel getLevel(java.util.logging.Level pName) {
        return JAVA_TO_LOGBACK.get(pName);
    }

    static {
        LogbackLevel[] levels;
        OFF = new LogbackLevel("off", Level.OFF, java.util.logging.Level.OFF, null);
        ALL = new LogbackLevel("all", Level.ALL, java.util.logging.Level.ALL, null);
        FATAL = new LogbackLevel("fatal", Level.ERROR, java.util.logging.Level.SEVERE, null);
        SEVERE = new LogbackLevel("severe", Level.ERROR, java.util.logging.Level.SEVERE, null);
        ERROR = new LogbackLevel("error", Level.ERROR, java.util.logging.Level.SEVERE, null);
        WARN = new LogbackLevel("warn", Level.WARN, java.util.logging.Level.WARNING, null);
        WARNING = new LogbackLevel("warning", Level.WARN, java.util.logging.Level.WARNING, null);
        INFO = new LogbackLevel("info", Level.INFO, java.util.logging.Level.INFO, null);
        CONFIG = new LogbackLevel("config", Level.INFO, java.util.logging.Level.CONFIG, null);
        FINE = new LogbackLevel("fine", Level.DEBUG, java.util.logging.Level.FINE, LogbackMarkers.FINE_MARKER);
        FINER = new LogbackLevel("finer", Level.DEBUG, java.util.logging.Level.FINER, LogbackMarkers.FINER_MARKER);
        FINEST = new LogbackLevel("finest", Level.TRACE, java.util.logging.Level.FINEST, LogbackMarkers.FINEST_MARKER);
        DEBUG = new LogbackLevel("debug", Level.DEBUG, java.util.logging.Level.FINE, null);
        TRACE = new LogbackLevel("trace", Level.TRACE, java.util.logging.Level.FINEST, null);
        $VALUES = new LogbackLevel[]{OFF, ALL, FATAL, SEVERE, ERROR, WARN, WARNING, INFO, CONFIG, FINE, FINER, FINEST, DEBUG, TRACE};
        CONVERSION = new HashMap<String, LogbackLevel>();
        JAVA_TO_LOGBACK = new HashMap<java.util.logging.Level, LogbackLevel>();
        for (LogbackLevel level : levels = LogbackLevel.values()) {
            CONVERSION.put(level.name, level);
        }
        JAVA_TO_LOGBACK.put(java.util.logging.Level.ALL, ALL);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.FINER, FINER);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.FINEST, FINEST);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.FINE, FINE);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.WARNING, WARNING);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.SEVERE, SEVERE);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.CONFIG, CONFIG);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.INFO, INFO);
        JAVA_TO_LOGBACK.put(java.util.logging.Level.OFF, OFF);
    }
}

