/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.ch.qos.logback.classic.Level;
import com.newrelic.agent.deps.ch.qos.logback.classic.Logger;
import com.newrelic.agent.deps.ch.qos.logback.classic.spi.ILoggingEvent;
import com.newrelic.agent.deps.ch.qos.logback.core.Appender;
import com.newrelic.agent.deps.ch.qos.logback.core.ConsoleAppender;
import com.newrelic.agent.deps.ch.qos.logback.core.Context;
import com.newrelic.agent.deps.ch.qos.logback.core.FileAppender;
import com.newrelic.agent.deps.ch.qos.logback.core.encoder.Encoder;
import com.newrelic.agent.deps.ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import com.newrelic.agent.deps.ch.qos.logback.core.rolling.RollingFileAppender;
import com.newrelic.agent.deps.ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import com.newrelic.agent.deps.ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.agent.logging.CustomPatternLogbackEncoder;
import com.newrelic.agent.logging.FineFilter;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.LogbackLevel;
import com.newrelic.agent.logging.LogbackMarkers;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LogbackLogger
implements IAgentLogger {
    private static final boolean PRUDENT_VALUE = false;
    private static final int MIN_FILE_COUNT = 1;
    private static final String CONSOLE_APPENDER_NAME = "Console";
    private static final String FILE_APPENDER_NAME = "File";
    private static final boolean APPEND_TO_FILE = true;
    private static final String CONVERSION_PATTERN = "%d{\"MMM d, yyyy HH:mm:ss ZZZZ\"} [%pid %i] %logger %ml: %m%n";
    private static final String SYSTEM_OUT = "System.out";
    private final Logger logger;
    private Map<String, IAgentLogger> childLoggers = Maps.newConcurrentMap();

    private LogbackLogger(String name, boolean isAgentRoot) {
        this.logger = (Logger)LoggerFactory.getLogger(name);
        if (isAgentRoot) {
            this.logger.setAdditive(false);
            FineFilter.getFineFilter().start();
        }
    }

    @Override
    public void severe(String pMessage) {
        this.logger.error(pMessage);
    }

    @Override
    public void error(String pMessage) {
        this.logger.error(pMessage);
    }

    @Override
    public void warning(String pMessage) {
        this.logger.warn(pMessage);
    }

    @Override
    public void info(String pMessage) {
        this.logger.info(pMessage);
    }

    @Override
    public void config(String pMessage) {
        this.logger.info(pMessage);
    }

    @Override
    public void fine(String pMessage) {
        this.logger.debug(LogbackMarkers.FINE_MARKER, pMessage);
    }

    @Override
    public void finer(String pMessage) {
        this.logger.debug(LogbackMarkers.FINER_MARKER, pMessage);
    }

    @Override
    public void finest(String pMessage) {
        this.logger.trace(LogbackMarkers.FINEST_MARKER, pMessage);
    }

    @Override
    public void debug(String pMessage) {
        this.logger.debug(pMessage);
    }

    @Override
    public void trace(String pMessage) {
        this.logger.trace(pMessage);
    }

    @Override
    public boolean isFineEnabled() {
        return this.logger.isDebugEnabled() && FineFilter.getFineFilter().isEnabledFor(java.util.logging.Level.FINE);
    }

    @Override
    public boolean isFinerEnabled() {
        return this.logger.isDebugEnabled() && FineFilter.getFineFilter().isEnabledFor(java.util.logging.Level.FINER);
    }

    @Override
    public boolean isFinestEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isLoggable(java.util.logging.Level pLevel) {
        LogbackLevel level = LogbackLevel.getLevel(pLevel);
        return level == null ? false : this.logger.isEnabledFor(level.getLogbackLevel()) && FineFilter.getFineFilter().isEnabledFor(pLevel);
    }

    @Override
    public void log(java.util.logging.Level pLevel, final String pMessage, final Throwable pThrowable) {
        if (this.isLoggable(pLevel)) {
            final LogbackLevel level = LogbackLevel.getLevel(pLevel);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    LogbackLogger.this.logger.log(level.getMarker(), Logger.FQCN, level.getLogbackLevel().toLocationAwareLoggerInteger(level.getLogbackLevel()), pMessage, null, pThrowable);
                    return null;
                }
            });
        }
    }

    @Override
    public void log(java.util.logging.Level pLevel, String pMessage) {
        LogbackLevel level = LogbackLevel.getLevel(pLevel);
        this.logger.log(level.getMarker(), Logger.FQCN, level.getLogbackLevel().toLocationAwareLoggerInteger(level.getLogbackLevel()), pMessage, null, null);
    }

    @Override
    public void log(java.util.logging.Level pLevel, String pMessage, Object[] pArgs, Throwable pThorwable) {
        LogbackLevel level = LogbackLevel.getLevel(pLevel);
        this.logger.log(level.getMarker(), Logger.FQCN, level.getLogbackLevel().toLocationAwareLoggerInteger(level.getLogbackLevel()), pMessage, pArgs, pThorwable);
    }

    @Override
    public IAgentLogger getChildLogger(Class<?> pClazz) {
        return this.getChildLogger(pClazz.getName());
    }

    @Override
    public IAgentLogger getChildLogger(String pFullName) {
        LogbackLogger logger = LogbackLogger.create(pFullName, false);
        this.childLoggers.put(pFullName, logger);
        return logger;
    }

    public void setLevel(String level) {
        LogbackLevel newLevel = LogbackLevel.getLevel(level, LogbackLevel.INFO);
        this.logger.setLevel(newLevel.getLogbackLevel());
        FineFilter.getFineFilter().setLevel(newLevel.getJavaLevel());
    }

    public String getLevel() {
        if (this.logger.getLevel() == Level.DEBUG) {
            return FineFilter.getFineFilter().getLevel().toString();
        }
        return this.logger.getLevel().toString();
    }

    public void removeConsoleAppender() {
        this.logger.detachAppender(CONSOLE_APPENDER_NAME);
    }

    public void addConsoleAppender() {
        if (this.logger.getAppender(CONSOLE_APPENDER_NAME) != null) {
            return;
        }
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>();
        consoleAppender.setName(CONSOLE_APPENDER_NAME);
        consoleAppender.setTarget(SYSTEM_OUT);
        consoleAppender.setEncoder(this.getEncoder(this.logger.getLoggerContext()));
        consoleAppender.setContext(this.logger.getLoggerContext());
        consoleAppender.addFilter(FineFilter.getFineFilter());
        consoleAppender.start();
        this.logger.addAppender((Appender<ILoggingEvent>)consoleAppender);
    }

    public void addFileAppender(String fileName, long logLimit, int fileCount, boolean isDaily) throws IOException {
        if (this.logger.getAppender(FILE_APPENDER_NAME) != null) {
            return;
        }
        FileAppender<ILoggingEvent> fileAppender = this.createFileAppender(fileCount, logLimit, fileName, isDaily);
        fileAppender.addFilter(FineFilter.getFineFilter());
        fileAppender.setEncoder(this.getEncoder(this.logger.getLoggerContext()));
        fileAppender.start();
        this.logger.addAppender((Appender<ILoggingEvent>)fileAppender);
    }

    private FileAppender<ILoggingEvent> createDailyAppender(int fileCount, String fileName) {
        RollingFileAppender<ILoggingEvent> fileAppender = new RollingFileAppender<ILoggingEvent>();
        fileAppender.setContext(this.logger.getLoggerContext());
        fileAppender.setName(FILE_APPENDER_NAME);
        fileAppender.setFile(fileName);
        fileAppender.setAppend(true);
        fileAppender.setPrudent(false);
        TimeBasedRollingPolicy timePolicy = new TimeBasedRollingPolicy();
        timePolicy.setFileNamePattern(fileName + ".%d{yyyy-MM-dd}");
        timePolicy.setContext(this.logger.getLoggerContext());
        timePolicy.setMaxHistory(fileCount);
        timePolicy.setParent(fileAppender);
        fileAppender.setRollingPolicy(timePolicy);
        timePolicy.start();
        return fileAppender;
    }

    private FileAppender<ILoggingEvent> createFileAppender(int fileCount, long logLimit, String fileName, boolean isDaily) {
        if (isDaily) {
            return this.createDailyAppender(fileCount, fileName);
        }
        if (fileCount <= 1) {
            FileAppender<ILoggingEvent> fileAppender = new FileAppender<ILoggingEvent>();
            fileAppender.setName(FILE_APPENDER_NAME);
            fileAppender.setFile(fileName);
            fileAppender.setAppend(true);
            fileAppender.setPrudent(false);
            fileAppender.setContext(this.logger.getLoggerContext());
            return fileAppender;
        }
        RollingFileAppender<ILoggingEvent> fileAppender = new RollingFileAppender<ILoggingEvent>();
        fileAppender.setContext(this.logger.getLoggerContext());
        fileAppender.setName(FILE_APPENDER_NAME);
        fileAppender.setFile(fileName);
        fileAppender.setAppend(true);
        fileAppender.setPrudent(false);
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setContext(this.logger.getLoggerContext());
        rollingPolicy.setParent(fileAppender);
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(fileCount);
        rollingPolicy.setFileNamePattern(fileName + ".%i");
        fileAppender.setRollingPolicy(rollingPolicy);
        SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy(String.valueOf(logLimit));
        fileAppender.setTriggeringPolicy(triggerPolicy);
        triggerPolicy.start();
        rollingPolicy.start();
        return fileAppender;
    }

    private Encoder<ILoggingEvent> getEncoder(Context context) {
        CustomPatternLogbackEncoder encoder = new CustomPatternLogbackEncoder(CONVERSION_PATTERN);
        encoder.setContext(context);
        encoder.start();
        return encoder;
    }

    public static LogbackLogger create(String name, boolean isAgentRoot) {
        return new LogbackLogger(name, isAgentRoot);
    }

    public void log(java.util.logging.Level level, String pattern, Object ... parts) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, parts));
        }
    }

    public void log(java.util.logging.Level level, Throwable t, String pattern, Object ... parts) {
        this.log(level, this.getMessage(pattern, parts), t);
    }

    private String getMessage(String pattern, Object ... parts) {
        return parts == null ? pattern : MessageFormat.format(pattern, this.formatValues(parts));
    }

    private Object[] formatValues(Object[] parts) {
        Object[] strings = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            strings[i] = this.formatValue(parts[i]);
        }
        return strings;
    }

    private Object formatValue(Object obj) {
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        if (obj instanceof Throwable) {
            return obj.toString();
        }
        return obj;
    }

    public void logToChild(String childName, java.util.logging.Level level, String pattern, Object ... parts) {
        if (this.isLoggable(level)) {
            IAgentLogger logger = this.childLoggers.get(childName);
            if (logger == null) {
                logger = Agent.LOG;
            }
            logger.log(level, pattern, parts);
        }
    }
}

