/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.metric;

import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public final class MetricName
implements JSONStreamAware {
    public static final MetricName WEB_TRANSACTION_ORM_ALL = MetricName.create("ORM/allWeb");
    public static final MetricName OTHER_TRANSACTION_ORM_ALL = MetricName.create("ORM/allOther");
    public static final MetricName WEB_TRANSACTION_SOLR_ALL = MetricName.create("Solr/allWeb");
    public static final MetricName OTHER_TRANSACTION_SOLR_ALL = MetricName.create("Solr/allOther");
    public static final MetricName QUEUE_TIME = MetricName.create("WebFrontend/QueueTime");
    public static final MetricName WEBFRONTEND_WEBSERVER_ALL = MetricName.create("WebFrontend/WebServer/all");
    private static final String NAME_KEY = "name";
    private static final String SCOPE_KEY = "scope";
    public static final String EMPTY_SCOPE = "";
    private final String name;
    private final String scope;
    private final int hashCode;

    private MetricName(String name, String scope) {
        this.name = name;
        this.scope = scope;
        this.hashCode = MetricName.generateHashCode(name, scope);
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isScoped() {
        return this.scope != EMPTY_SCOPE;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static int generateHashCode(String name, String scope) {
        int prime = 31;
        int result = 1;
        result = 31 * result + name.hashCode();
        result = 31 * result + scope.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricName other = (MetricName)obj;
        return this.name.equals(other.name) && this.scope.equals(other.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.isScoped()) {
            sb.append(" (").append(this.scope).append(')');
        }
        return sb.toString();
    }

    public void writeJSONString(Writer writer) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>(3);
        if (this.isScoped()) {
            props.put(SCOPE_KEY, this.scope);
        }
        props.put(NAME_KEY, this.name);
        JSONObject.writeJSONString(props, writer);
    }

    public static MetricName create(String name, String scope) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (scope == null || scope.length() == 0) {
            scope = EMPTY_SCOPE;
        }
        return new MetricName(name, scope);
    }

    public static MetricName create(String name) {
        return MetricName.create(name, null);
    }

    public static MetricName parseJSON(JSONObject jsonObj) {
        String scope = (String)String.class.cast(jsonObj.get(SCOPE_KEY));
        String name = (String)String.class.cast(jsonObj.get(NAME_KEY));
        return MetricName.create(name, scope);
    }
}

