/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import com.newrelic.agent.platform.AbstractPlatformCommand;
import com.newrelic.agent.platform.WindowsPlatformInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWindowsPlatformCommand<T>
extends AbstractPlatformCommand<T> {
    private static final String DEFAULT_SYSTEM_ROOT = "C:\\Windows";
    private static final String SYSTEMROOT_ENV_VAR = "SystemRoot";
    private static final String WMIC_SUBPATH = "System32\\Wbem\\wmic";

    AbstractWindowsPlatformCommand(String command, String[] args) {
        super(command, args);
    }

    static final String buildWmicCommand() {
        if (!WindowsPlatformInspector.isWindows()) {
            return "#";
        }
        String systemRoot = System.getenv(SYSTEMROOT_ENV_VAR);
        if (systemRoot == null) {
            systemRoot = DEFAULT_SYSTEM_ROOT;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.finer(String.format("Platform inspector found no SystemRoot in the environment: using %s", systemRoot));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(systemRoot);
        if (!systemRoot.endsWith("\\")) {
            sb.append("\\");
        }
        sb.append(WMIC_SUBPATH);
        String result = sb.toString();
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.finer("Platform inspector: wmic: " + result);
        }
        return result;
    }
}

