/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

class LinuxPhysicalCoreCountProvider {
    private static final String PROCESSOR = "processor";
    private static final String PHYSICAL_ID = "physical id";
    private static final String CPU_CORES = "cpu cores";
    private static final String COLON = ":";

    LinuxPhysicalCoreCountProvider() {
    }

    static Integer getPhysicalCoreCount() {
        return LinuxPhysicalCoreCountProvider.getCoreCount(new File("/proc/cpuinfo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Integer getCoreCount(File cpuInfo) {
        String[] parts;
        if (!cpuInfo.canRead()) {
            Agent.LOG.log(Level.FINE, "Cannot read /proc/cpuinfo. Unable to obtain number of physical CPUs.");
            return null;
        }
        BufferedReader reader = null;
        LinuxCpuInfo parsingInfo = new LinuxCpuInfo();
        try {
            try {
                String line;
                reader = new BufferedReader(new FileReader(cpuInfo));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim().toLowerCase()).startsWith(PROCESSOR)) {
                        parsingInfo.finishPreviousProcessor();
                        parsingInfo.newProcessorSeen();
                        parsingInfo.clear();
                        continue;
                    }
                    parts = line.split(COLON);
                    if (parts == null || parts.length != 2) continue;
                    if (parts[0].startsWith(PHYSICAL_ID)) {
                        parsingInfo.setPhysicalId(parts[1]);
                        continue;
                    }
                    if (!parts[0].startsWith(CPU_CORES)) continue;
                    parsingInfo.setCpuCores(parts[1]);
                }
                parsingInfo.finishPreviousProcessor();
                parts = parsingInfo.getTotalCorecount();
                Object var7_6 = null;
                if (reader == null) return parts;
            }
            catch (Exception e) {
                Agent.LOG.log(Level.INFO, "Cannot obtain number of physical CPUs from /proc/cpuinfo.");
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.FINEST, "Unexpected Exception: ", e);
                }
                Integer n = null;
                Object var7_7 = null;
                if (reader == null) return n;
                try {
                    reader.close();
                    return n;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (reader == null) throw throwable;
            try {}
            catch (IOException e2) {
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return parts;
        }
        reader.close();
        return parts;
    }

    private static class LinuxCpuInfo {
        private Integer physicalId = null;
        private Integer cpuCores = null;
        int nProcessorsSeen = 0;
        private final Map<Integer, Integer> physicalIdToCores = new HashMap<Integer, Integer>();

        private LinuxCpuInfo() {
        }

        void clear() {
            this.physicalId = null;
            this.cpuCores = null;
        }

        void setPhysicalId(String id) {
            this.physicalId = LinuxCpuInfo.getIntValue(id);
        }

        void setCpuCores(String cores) {
            this.cpuCores = LinuxCpuInfo.getIntValue(cores);
        }

        private static Integer getIntValue(String inputValue) {
            try {
                return Integer.valueOf(inputValue.trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        void finishPreviousProcessor() {
            if (this.physicalId != null && this.cpuCores != null) {
                Integer oldValue = this.physicalIdToCores.get(this.physicalId);
                if (oldValue != null && oldValue.intValue() != this.cpuCores.intValue()) {
                    Agent.LOG.log(Level.FINE, "There are two different cpu core counts for the same physical id.");
                }
                this.physicalIdToCores.put(this.physicalId, this.cpuCores);
            }
        }

        void newProcessorSeen() {
            ++this.nProcessorsSeen;
        }

        Integer getTotalCorecount() {
            if (this.physicalIdToCores.isEmpty()) {
                return this.nProcessorsSeen;
            }
            int totalCount = 0;
            for (Integer current : this.physicalIdToCores.values()) {
                totalCount += current.intValue();
            }
            return totalCount;
        }
    }
}

