/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.platform.AbstractPlatformInspector;
import com.newrelic.agent.platform.LinuxPlatformInspector;
import com.newrelic.agent.platform.MacPlatformInspector;
import com.newrelic.agent.platform.SolarisPlatformInspector;
import com.newrelic.agent.platform.UnregisteredThreadFactory;
import com.newrelic.agent.platform.WindowsPlatformInspector;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformInfo {
    private final AbstractPlatformInspector inspector;
    private final ExecutorService executor;
    private volatile Integer physicalCoreCount = null;
    private volatile Float physicalMemoryInMB = null;

    private static List<AbstractPlatformInspector> getPlatformInspectors(ExecutorService executor) {
        return Arrays.asList(new LinuxPlatformInspector(executor), new WindowsPlatformInspector(executor), new SolarisPlatformInspector(executor), new MacPlatformInspector(executor));
    }

    private static AbstractPlatformInspector getInspector(ExecutorService executor) {
        for (AbstractPlatformInspector pi : PlatformInfo.getPlatformInspectors(executor)) {
            if (!pi.recognizesPlatform()) continue;
            return pi;
        }
        return null;
    }

    private PlatformInfo(AbstractPlatformInspector inspector, ExecutorService executor) {
        if (inspector == null) {
            throw new IllegalArgumentException("inspector");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor");
        }
        this.inspector = inspector;
        this.executor = executor;
    }

    public static final PlatformInfo create(AgentConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config");
        }
        if (!config.isPlatformInformationEnabled()) {
            Agent.LOG.info("Physical host configuration will not be available. It has been disabled in the Agent configuration.");
            return null;
        }
        UnregisteredThreadFactory factory = new UnregisteredThreadFactory("New Relic Command Executor", true);
        ExecutorService executor = Executors.newSingleThreadExecutor(factory);
        AbstractPlatformInspector inspector = PlatformInfo.getInspector(executor);
        if (inspector == null) {
            Agent.LOG.info("Physical host configuration is not available for this platform.");
            return null;
        }
        PlatformInfo instance = new PlatformInfo(inspector, executor);
        inspector.start(config);
        return instance;
    }

    public Integer getPhysicalCoreCount() {
        if (this.physicalCoreCount == null) {
            this.physicalCoreCount = this.inspector.getPhysicalCoreCount();
        }
        return this.physicalCoreCount;
    }

    public Float getPhysicalMemoryInMB() {
        if (this.physicalMemoryInMB == null) {
            this.physicalMemoryInMB = this.inspector.getPhysicalMemoryInMB();
        }
        return this.physicalMemoryInMB;
    }

    public void terminate() {
        if (this.inspector != null) {
            Agent.LOG.fine("PlatformInfo: forcing shutdown of ExecutorService");
            this.executor.shutdownNow();
        }
    }
}

