/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import com.newrelic.agent.platform.AbstractWindowsPlatformCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Windows2008PhysicalMemoryCommand
extends AbstractWindowsPlatformCommand<Float> {
    private static final String[] ARGS = new String[]{"computersystem", "get", "TotalPhysicalMemory", "/value"};
    private volatile Float resultInMB = null;
    private boolean errorSeen = false;

    Windows2008PhysicalMemoryCommand() {
        super(Windows2008PhysicalMemoryCommand.buildWmicCommand(), ARGS);
    }

    @Override
    Float getValue() {
        return this.resultInMB;
    }

    private static float convertResultToMB(String valueInBytes) {
        return Float.parseFloat(valueInBytes) / 1048576.0f;
    }

    @Override
    void processChildLine(String line) {
        if (this.errorSeen) {
            return;
        }
        String key = "TotalPhysicalMemory=";
        if ((line = line.trim()).length() == 0) {
            return;
        }
        if (line.startsWith("TotalPhysicalMemory=")) {
            this.resultInMB = this.resultInMB == null ? Float.valueOf(Windows2008PhysicalMemoryCommand.convertResultToMB(line.substring("TotalPhysicalMemory=".length()))) : Float.valueOf(this.resultInMB.floatValue() + Windows2008PhysicalMemoryCommand.convertResultToMB(line.substring("TotalPhysicalMemory=".length())));
        } else {
            Agent.LOG.fine("extra output while getting physical memory size");
            this.errorSeen = true;
            this.resultInMB = null;
        }
    }
}

