/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.platform.AbstractPlatformInspector;
import com.newrelic.agent.platform.AsyncCommandRunner;
import com.newrelic.agent.platform.DefaultPhysicalMemoryProvider;
import com.newrelic.agent.platform.Windows2008PhysicalMemoryCommand;
import com.newrelic.agent.platform.WindowsPhysicalCoreCountCommand;
import java.util.concurrent.ExecutorService;

class WindowsPlatformInspector
extends AbstractPlatformInspector {
    private static final String OS_ARCH = "os.arch";
    private static final String OS_ARCH_WINDOWS_2008 = "Windows 2008";
    private static final String OS_NAME = "os.name";
    private static final String OS_NAME_WINDOWS = "Windows";
    private static final String OS_ARCH_UNKNOWN = "?";
    private final AsyncCommandRunner<Integer> coreCountRunner;
    private final AsyncCommandRunner<Float> physicalMemoryRunner;

    WindowsPlatformInspector(ExecutorService executor) {
        this.coreCountRunner = new AsyncCommandRunner<Integer>(new WindowsPhysicalCoreCountCommand(), executor);
        this.physicalMemoryRunner = this.isWindows2008() ? new AsyncCommandRunner<Float>(new Windows2008PhysicalMemoryCommand(), executor) : null;
    }

    boolean recognizesPlatform() {
        return WindowsPlatformInspector.isWindows();
    }

    void start(AgentConfig config) {
        this.coreCountRunner.start();
        if (this.physicalMemoryRunner != null) {
            this.physicalMemoryRunner.start();
        }
    }

    boolean isDone() {
        return this.coreCountRunner.isDone() && (this.physicalMemoryRunner == null || this.physicalMemoryRunner.isDone());
    }

    Integer getPhysicalCoreCount() {
        return this.coreCountRunner.getCommand().getValue();
    }

    Float getPhysicalMemoryInMB() {
        Float result = null;
        result = this.physicalMemoryRunner == null ? DefaultPhysicalMemoryProvider.getPhysicalMemoryInMB() : this.physicalMemoryRunner.getCommand().getValue();
        return result;
    }

    static final boolean isWindows() {
        return System.getProperty(OS_NAME).startsWith(OS_NAME_WINDOWS);
    }

    private boolean isWindows2008() {
        return System.getProperty(OS_ARCH, OS_ARCH_UNKNOWN).startsWith(OS_ARCH_WINDOWS_2008);
    }
}

