/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.profile.AbstractController;
import com.newrelic.agent.profile.ProfilingTask;
import com.newrelic.agent.profile.ProfilingTaskController;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;

public class XrayCpuTimeController
extends AbstractController
implements ProfilingTaskController {
    private long threadId;
    private long startCpuTimeInNanos;
    private long startTimeInNanos;
    private volatile long currentThreadId = Thread.currentThread().getId();

    public XrayCpuTimeController(ProfilingTask profilingTask) {
        super(profilingTask);
    }

    public void run() {
        this.currentThreadId = Thread.currentThread().getId();
        super.run();
    }

    protected int doCalculateSamplePeriodInMillis() {
        long endCpuTimeInNanos;
        int samplePeriod = this.getSamplePeriodInMillis();
        long nThreadId = this.getCurrentThreadId();
        long oThreadId = this.threadId;
        this.threadId = nThreadId;
        try {
            endCpuTimeInNanos = this.getThreadCpuTimeInNanos();
        }
        catch (Throwable t) {
            Agent.LOG.fine(MessageFormat.format("Error getting thread cpu time: {0}", t));
            return samplePeriod;
        }
        long endTimeInNanos = this.getTimeInNanos();
        if (oThreadId == nThreadId) {
            samplePeriod = this.calculateSamplePeriod(endTimeInNanos - this.startTimeInNanos, endCpuTimeInNanos - this.startCpuTimeInNanos);
        }
        this.startCpuTimeInNanos = endCpuTimeInNanos;
        this.startTimeInNanos = endTimeInNanos;
        return samplePeriod;
    }

    private int calculateSamplePeriod(long timeInNanos, long cpuTimeInNanos) {
        if (cpuTimeInNanos == 0L || timeInNanos == 0L) {
            return this.getSamplePeriodInMillis();
        }
        float cpuUtilization = (float)cpuTimeInNanos / (float)(timeInNanos * (long)this.getProcessorCount());
        return (int)(cpuUtilization * (float)this.getSamplePeriodInMillis() / TARGET_UTILIZATION);
    }

    protected long getThreadCpuTimeInNanos() {
        return ManagementFactory.getThreadMXBean().getThreadCpuTime(this.threadId);
    }

    protected long getCurrentThreadId() {
        return this.currentThreadId;
    }

    protected long getTimeInNanos() {
        return System.nanoTime();
    }
}

