/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ProfilingTaskController;
import com.newrelic.agent.profile.ProfilingTaskControllerFactory;
import com.newrelic.agent.profile.XrayProfilingTask;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.xray.XRaySession;
import com.newrelic.agent.xray.XRaySessionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class XrayProfileSession
implements HarvestListener,
XRaySessionListener {
    private static Long PROFILE_ID = -1L;
    private static boolean ONLY_RUNNABLE_THREADS = true;
    private static boolean ONLY_REQUEST_THREADS = true;
    private static boolean PROFILE_AGENT_CODE = false;
    private ScheduledFuture<?> profileHandle;
    private final ProfilingTaskController profilingTaskController;
    private final String defaultApplication;
    private final Map<Long, ProfilerParameters> profilerParameters = new HashMap<Long, ProfilerParameters>();
    private boolean isSuspended;

    public XrayProfileSession() {
        this.defaultApplication = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();
        this.profilingTaskController = ProfilingTaskControllerFactory.createProfilingTaskController(new XrayProfilingTask());
    }

    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }

    public void afterHarvest(String appName) {
        if (this.defaultApplication.equals(appName)) {
            if (this.isSuspended && ServiceFactory.getProfilerService().getCurrentSession() == null) {
                this.resume();
            }
            if (this.profileHandle != null) {
                long oSamplePeriod = this.profilingTaskController.getSamplePeriodInMillis();
                this.profilingTaskController.afterHarvest(appName);
                long nSamplePeriod = this.profilingTaskController.getSamplePeriodInMillis();
                if (nSamplePeriod != oSamplePeriod) {
                    this.stop();
                    this.start();
                }
            }
        }
    }

    public void xraySessionCreated(XRaySession session) {
        if (session.isRunProfiler()) {
            ProfilerParameters parameters = new ProfilerParameters(PROFILE_ID, session.getSamplePeriodMilliseconds(), session.getDurationMilliseconds(), ONLY_RUNNABLE_THREADS, ONLY_REQUEST_THREADS, PROFILE_AGENT_CODE, session.getKeyTransactionName(), session.getxRayId(), session.getApplicationName());
            if (!this.profilerParameters.containsKey(session.getxRayId())) {
                this.profilerParameters.put(parameters.getXraySessionId(), parameters);
                this.startProfiling(parameters);
            }
        }
    }

    public void xraySessionRemoved(XRaySession session) {
        ProfilerParameters parameters;
        if (session.isRunProfiler() && (parameters = this.profilerParameters.remove(session.getxRayId())) != null) {
            this.stopProfiling(parameters);
        }
    }

    private void startProfiling(ProfilerParameters parameters) {
        this.profilingTaskController.addProfile(parameters);
        String msg = MessageFormat.format("Added xray session profiling for {0}", parameters.getKeyTransaction());
        Agent.LOG.info(msg);
        if (!this.isSuspended) {
            this.start();
        }
    }

    private void stopProfiling(ProfilerParameters parameters) {
        this.profilingTaskController.removeProfile(parameters);
        String msg = MessageFormat.format("Removed xray session profiling for {0}", parameters.getKeyTransaction());
        Agent.LOG.info(msg);
        if (this.profilerParameters.isEmpty()) {
            this.stop();
        }
    }

    private void start() {
        if (this.profileHandle == null) {
            long delay = this.profilingTaskController.getSamplePeriodInMillis();
            ScheduledExecutorService scheduler = ServiceFactory.getProfilerService().getScheduledExecutorService();
            this.profileHandle = scheduler.scheduleWithFixedDelay(this.profilingTaskController, 0L, delay, TimeUnit.MILLISECONDS);
            Agent.LOG.fine(MessageFormat.format("Started xray profiling task delay = {0}", delay));
        }
    }

    private void stop() {
        if (this.profileHandle != null) {
            this.profileHandle.cancel(false);
            this.profileHandle = null;
            ScheduledExecutorService scheduler = ServiceFactory.getProfilerService().getScheduledExecutorService();
            scheduler.schedule(this.profilingTaskController, 0L, TimeUnit.MILLISECONDS);
            Agent.LOG.fine("Stopped xray profiling task");
        }
    }

    public void suspend() {
        if (!this.isSuspended) {
            this.isSuspended = true;
            this.stop();
            Agent.LOG.fine("Suspended xray profiling session");
        }
    }

    private void resume() {
        if (this.isSuspended) {
            this.isSuspended = false;
            if (!this.profilerParameters.isEmpty()) {
                this.start();
            }
            Agent.LOG.fine("Resumed xray profiling session");
        }
    }

    ProfilingTaskController getProfilingTaskController() {
        return this.profilingTaskController;
    }
}

