/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.method;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.profile.MethodLineNumberMatcher;
import com.newrelic.agent.profile.method.ExactMethodInfo;
import com.newrelic.agent.profile.method.MethodInfo;
import com.newrelic.agent.profile.method.MultipleMethodInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfoUtil {
    public static MethodInfo createMethodInfo(Class<?> declaringClass, String methodName, int lineNumber) {
        String methodDesc = MethodLineNumberMatcher.getMethodDescription(declaringClass, methodName, lineNumber);
        return MethodInfoUtil.getMethodInfo(declaringClass, methodName, methodDesc);
    }

    protected static MethodInfo getMethodInfo(Class<?> declaringClass, String methodName, String methodDesc) {
        if (methodDesc == null) {
            return MethodInfoUtil.handleNoMethodDesc(declaringClass, methodName);
        }
        List<String> args = MethodInfoUtil.getArguments(methodDesc);
        if (MethodInfoUtil.isConstructor(methodName)) {
            return MethodInfoUtil.handleConstructor(declaringClass, methodName, methodDesc, args);
        }
        return MethodInfoUtil.handleMethod(declaringClass, methodName, methodDesc, args);
    }

    private static MethodInfo handleMethod(Class<?> declaringClass, String methodName, String methodDesc, List<String> args) {
        ArrayList<Member> members = Lists.newArrayList();
        if (MethodInfoUtil.getMethod(members, declaringClass, methodName, args)) {
            return new ExactMethodInfo(args, (Member)members.get(0));
        }
        return new MultipleMethodInfo(Sets.newHashSet(members));
    }

    private static MethodInfo handleConstructor(Class<?> declaringClass, String methodName, String methodDesc, List<String> args) {
        ArrayList<Member> members = Lists.newArrayList();
        if (MethodInfoUtil.getConstructor(members, declaringClass, methodName, args)) {
            return new ExactMethodInfo(args, (Member)members.get(0));
        }
        return new MultipleMethodInfo(Sets.newHashSet(members));
    }

    private static MethodInfo handleNoMethodDesc(Class<?> declaringClass, String methodName) {
        if (MethodInfoUtil.isConstructor(methodName)) {
            return new MultipleMethodInfo(Sets.newHashSet(declaringClass.getDeclaredConstructors()));
        }
        return new MultipleMethodInfo(MethodInfoUtil.getMatchingMethods(declaringClass, methodName));
    }

    protected static List<String> getArguments(Member m) {
        ArrayList<String> paramClasses = Lists.newArrayList();
        Class<Object>[] params = m instanceof Method ? ((Method)m).getParameterTypes() : (m instanceof Constructor ? ((Constructor)m).getParameterTypes() : new Class[]{});
        for (Class<?> clazz : params) {
            paramClasses.add(clazz.getCanonicalName());
        }
        return paramClasses;
    }

    protected static List<String> getArguments(String methodDesc) {
        Type[] types = Type.getArgumentTypes(methodDesc);
        ArrayList<String> args = Lists.newArrayListWithCapacity(types.length);
        for (Type current : types) {
            args.add(current.getClassName());
        }
        return args;
    }

    private static boolean isConstructor(String methodName) {
        return methodName.startsWith("<");
    }

    private static boolean getConstructor(List<Member> addToHere, Class<?> declaringClass, String constName, List<String> arguments) {
        for (Constructor<?> constructor : declaringClass.getDeclaredConstructors()) {
            addToHere.add(constructor);
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != arguments.size()) continue;
            boolean matches = true;
            for (int i = 0; i < params.length; ++i) {
                if (arguments.get(i).equals(params[i].getCanonicalName())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            addToHere.clear();
            addToHere.add(constructor);
            return true;
        }
        return false;
    }

    protected static boolean getMethod(List<Member> addToHere, Class<?> declaringClass, String methodName, List<String> arguments) {
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            addToHere.add(method);
            Class<?>[] params = method.getParameterTypes();
            if (params.length != arguments.size()) continue;
            boolean matches = true;
            for (int i = 0; i < params.length; ++i) {
                if (arguments.get(i).equals(params[i].getCanonicalName())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            addToHere.clear();
            addToHere.add(method);
            return true;
        }
        return false;
    }

    protected static Set<Member> getMatchingMethods(Class<?> declaringClass, String methodName) {
        HashSet<Member> methods = Sets.newHashSet();
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            methods.add(method);
        }
        return methods;
    }
}

