/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;

public class MemorySampler
implements MetricSampler {
    public static final float BYTES_PER_MB = 1048576.0f;
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();

    void start() {
    }

    public void sample(StatsEngine statsEngine) {
        this.sampleMemory(statsEngine);
        this.sampleMemoryPools(statsEngine);
    }

    private void sampleMemory(StatsEngine statsEngine) {
        try {
            HeapAndNonHeapUsage heapUsage = new HeapAndNonHeapUsage(this.memoryMXBean);
            heapUsage.recordStats(statsEngine);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred gathering memory metrics: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.WARNING, msg, e);
            }
            Agent.LOG.warning(msg);
        }
    }

    private void sampleMemoryPools(StatsEngine statsEngine) {
        try {
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                PoolUsage poolUsage = new PoolUsage(memoryPoolMXBean);
                poolUsage.recordStats(statsEngine);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred gathering memory pool metrics: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.WARNING, msg, e);
            }
            Agent.LOG.warning(msg);
        }
    }

    private static final class PoolUsage {
        private final String name;
        private final String type;
        private final long used;
        private final long committed;
        private final long max;

        private PoolUsage(MemoryPoolMXBean memoryPoolMXBean) {
            this.name = memoryPoolMXBean.getName();
            this.type = memoryPoolMXBean.getType() == MemoryType.HEAP ? "Heap" : "Non-Heap";
            MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
            this.used = memoryUsage.getUsed();
            this.committed = memoryUsage.getCommitted();
            this.max = memoryUsage.getMax();
        }

        public void recordStats(StatsEngine statsEngine) {
            String metricName = MessageFormat.format("MemoryPool/{0}/{1}/Used", this.type, this.name);
            statsEngine.getStats(metricName).recordDataPoint(this.getUsed());
            metricName = MessageFormat.format("MemoryPool/{0}/{1}/Committed", this.type, this.name);
            statsEngine.getStats(metricName).recordDataPoint(this.getCommitted());
            metricName = MessageFormat.format("MemoryPool/{0}/{1}/Max", this.type, this.name);
            statsEngine.getStats(metricName).recordDataPoint(this.getMax());
        }

        private float getUsed() {
            return (float)this.used / 1048576.0f;
        }

        private float getCommitted() {
            return (float)this.committed / 1048576.0f;
        }

        private float getMax() {
            return (float)this.max / 1048576.0f;
        }
    }

    private static final class HeapAndNonHeapUsage {
        private final long heapUsed;
        private final long heapCommitted;
        private final long heapMax;
        private final long nonHeapUsed;
        private final long nonHeapCommitted;
        private final long nonHeapMax;

        private HeapAndNonHeapUsage(MemoryMXBean memoryMXBean) {
            MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
            this.nonHeapCommitted = nonHeapMemoryUsage.getCommitted();
            this.nonHeapUsed = nonHeapMemoryUsage.getUsed();
            this.nonHeapMax = nonHeapMemoryUsage.getMax();
            MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
            this.heapUsed = heapMemoryUsage.getUsed();
            this.heapCommitted = heapMemoryUsage.getCommitted();
            this.heapMax = heapMemoryUsage.getMax();
        }

        public void recordStats(StatsEngine statsEngine) {
            statsEngine.getStats("Memory/Physical").recordDataPoint(this.getCommitted());
            statsEngine.getStats("Memory/Used").recordDataPoint(this.getUsed());
            statsEngine.getStats("Memory/Heap/Used").recordDataPoint(this.getHeapUsed());
            statsEngine.getStats("Memory/Heap/Committed").recordDataPoint(this.getHeapCommitted());
            statsEngine.getStats("Memory/Heap/Max").recordDataPoint(this.getHeapMax());
            statsEngine.getStats("Memory/NonHeap/Used").recordDataPoint(this.getNonHeapUsed());
            statsEngine.getStats("Memory/NonHeap/Committed").recordDataPoint(this.getNonHeapCommitted());
            statsEngine.getStats("Memory/NonHeap/Max").recordDataPoint(this.getNonHeapMax());
        }

        private float getCommitted() {
            return (float)(this.nonHeapCommitted + this.heapCommitted) / 1048576.0f;
        }

        private float getUsed() {
            return (float)(this.nonHeapUsed + this.heapUsed) / 1048576.0f;
        }

        private float getHeapUsed() {
            return (float)this.heapUsed / 1048576.0f;
        }

        private float getHeapCommitted() {
            return (float)this.heapCommitted / 1048576.0f;
        }

        private float getHeapMax() {
            return (float)this.heapMax / 1048576.0f;
        }

        private float getNonHeapUsed() {
            return (float)this.nonHeapUsed / 1048576.0f;
        }

        private float getNonHeapCommitted() {
            return (float)this.nonHeapCommitted / 1048576.0f;
        }

        private float getNonHeapMax() {
            return (float)this.nonHeapMax / 1048576.0f;
        }
    }
}

