/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.samplers.AbstractCPUSampler;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;

public class ProcStatCPUSampler
extends AbstractCPUSampler {
    private final File statFile;
    private final long clockTicksPerSecond;

    public ProcStatCPUSampler(File statFile) throws Exception {
        this.statFile = statFile;
        this.clockTicksPerSecond = this.getClockTicksPerSecond();
        this.readCPUStats();
    }

    private long getClockTicksPerSecond() {
        long defaultClockTicks = 100L;
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        return config.getProperty("clock_ticks_per_second", defaultClockTicks);
    }

    protected double getProcessCpuTime() {
        try {
            CPUStats stats = this.readCPUStats();
            Agent.LOG.finest("CPU Stats " + stats);
            if (stats == null) {
                return 0.0;
            }
            return stats.getSystemTime() + stats.getUserTime();
        }
        catch (IOException e) {
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private CPUStats readCPUStats() throws IOException {
        block11: {
            String systemTime;
            String userTime;
            FileInputStream iStream;
            block9: {
                ByteArrayOutputStream oStream = new ByteArrayOutputStream(8192);
                iStream = new FileInputStream(this.statFile);
                userTime = "";
                systemTime = "";
                Streams.copy(iStream, oStream);
                oStream.close();
                String[] stats = oStream.toString().split(" ");
                if (stats.length <= 13) break block9;
                userTime = stats[13];
                systemTime = stats[14];
                CPUStats cPUStats = new CPUStats(Long.parseLong(userTime), Long.parseLong(systemTime));
                Object var8_9 = null;
                try {
                    iStream.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return cPUStats;
            }
            Object var8_10 = null;
            try {
                iStream.close();
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (NumberFormatException e) {
                    Agent.LOG.fine(MessageFormat.format("Badly formatted CPU jiffies: ''{0}'' user, ''{1}'' system", userTime, systemTime));
                    CPUStats cPUStats = null;
                    Object var8_11 = null;
                    try {
                        iStream.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return cPUStats;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    iStream.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    private class CPUStats {
        private final double userTime;
        private final double systemTime;

        public CPUStats(long userTime, long systemTime) {
            this.userTime = userTime / ProcStatCPUSampler.this.clockTicksPerSecond;
            this.systemTime = systemTime / ProcStatCPUSampler.this.clockTicksPerSecond;
        }

        public double getUserTime() {
            return this.userTime;
        }

        public double getSystemTime() {
            return this.systemTime;
        }

        public String toString() {
            return "User: " + this.userTime + ", System: " + this.systemTime;
        }
    }
}

