/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ServiceUtils {
    private static final int ROTATED_BIT_SHIFT = 31;
    private static final String PATH_HASH_SEPARATOR = ";";

    public static int calculatePathHash(String appName, String txName, Integer optionalReferringPathHash) {
        int referringPathHash = optionalReferringPathHash == null ? 0 : optionalReferringPathHash;
        int rotatedReferringPathHash = referringPathHash << 1 | referringPathHash >>> 31;
        return rotatedReferringPathHash ^ ServiceUtils.getHash(appName, txName);
    }

    public static int reversePathHash(String appName, String txName, Integer optionalReferringPathHash) {
        int referringPathHash = optionalReferringPathHash == null ? 0 : optionalReferringPathHash;
        int rotatedReferringPathHash = referringPathHash ^ ServiceUtils.getHash(appName, txName);
        return rotatedReferringPathHash >>> 1 | rotatedReferringPathHash << 31;
    }

    private static int getHash(String appName, String txName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest((appName + PATH_HASH_SEPARATOR + txName).getBytes("UTF-8"));
            int fromBytes = (digest[12] & 0xFF) << 24 | (digest[13] & 0xFF) << 16 | (digest[14] & 0xFF) << 8 | digest[15] & 0xFF;
            return fromBytes;
        }
        catch (NoSuchAlgorithmException e) {
            return 0;
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
    }

    public static String intToHexString(int val) {
        return String.format("%08x", val);
    }

    public static int hexStringToInt(String val) {
        return (int)Long.parseLong(val, 16);
    }
}

