/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.agent.stats.ApdexPerfZone;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionEvent
implements JSONStreamAware {
    static final float UNASSIGNED = Float.NEGATIVE_INFINITY;
    static final int UNASSIGNED_INT = Integer.MIN_VALUE;
    static final String type = "Transaction";
    final long timestamp;
    final String guid;
    final String referrerGuid;
    final String tripId;
    final Integer referringPathHash;
    Integer pathHash;
    final String alternatePathHashes;
    final ApdexPerfZone apdexPerfZone;
    final int port;
    final String name;
    final float duration;
    float queueDuration = Float.NEGATIVE_INFINITY;
    float externalDuration = Float.NEGATIVE_INFINITY;
    float externalCallCount = Float.NEGATIVE_INFINITY;
    float databaseDuration = Float.NEGATIVE_INFINITY;
    float databaseCallCount = Float.NEGATIVE_INFINITY;
    float gcCumulative = Float.NEGATIVE_INFINITY;
    Map<String, Object> userAttributes;
    Map<String, Object> agentAttributes;
    String appName;

    public TransactionEvent(String appName, String subType, long timestamp, String name, float duration, String guid, String referringGuid, Integer port, String tripId, Integer referringPathHash, String alternatePathHashes, ApdexPerfZone apdexPerfZone) {
        this.timestamp = timestamp;
        this.name = name;
        this.duration = duration;
        this.guid = guid;
        this.referrerGuid = referringGuid;
        this.tripId = tripId;
        this.referringPathHash = referringPathHash;
        this.alternatePathHashes = alternatePathHashes;
        this.port = port == null ? Integer.MIN_VALUE : port;
        this.appName = appName;
        this.apdexPerfZone = apdexPerfZone;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("type", type);
        obj.put("timestamp", this.timestamp);
        obj.put("name", this.name);
        obj.put("duration", Float.valueOf(this.duration));
        if (this.apdexPerfZone != null) {
            obj.put("apdexPerfZone", this.apdexPerfZone.getZone());
        }
        if (this.guid != null) {
            obj.put("nr.guid", this.guid);
        }
        if (this.referrerGuid != null) {
            obj.put("nr.referringTransactionGuid", this.referrerGuid);
        }
        if (this.tripId != null) {
            obj.put("nr.tripId", this.tripId);
        }
        if (this.pathHash != null) {
            obj.put("nr.pathHash", ServiceUtils.intToHexString(this.pathHash));
        }
        if (this.referringPathHash != null) {
            obj.put("nr.referringPathHash", ServiceUtils.intToHexString(this.referringPathHash));
        }
        if (this.alternatePathHashes != null) {
            obj.put("nr.alternatePathHashes", this.alternatePathHashes);
        }
        if (this.port != Integer.MIN_VALUE) {
            obj.put("port", this.port);
        }
        if (this.queueDuration != Float.NEGATIVE_INFINITY) {
            obj.put("queueDuration", Float.valueOf(this.queueDuration));
        }
        if (this.externalDuration != Float.NEGATIVE_INFINITY) {
            obj.put("externalDuration", Float.valueOf(this.externalDuration));
        }
        if (this.externalCallCount > 0.0f) {
            obj.put("externalCallCount", Float.valueOf(this.externalCallCount));
        }
        if (this.databaseDuration != Float.NEGATIVE_INFINITY) {
            obj.put("databaseDuration", Float.valueOf(this.databaseDuration));
        }
        if (this.databaseCallCount > 0.0f) {
            obj.put("databaseCallCount", Float.valueOf(this.databaseCallCount));
        }
        if (this.gcCumulative != Float.NEGATIVE_INFINITY) {
            obj.put("gcCumulative", Float.valueOf(this.gcCumulative));
        }
        Map<String, ? extends Object> filteredUserAtts = this.getUserFilteredMap(this.userAttributes);
        Map<String, ? extends Object> filteredAgentAtts = this.getFilteredMap(this.agentAttributes);
        if (filteredAgentAtts.isEmpty()) {
            if (filteredUserAtts.isEmpty()) {
                JSONArray.writeJSONString(Arrays.asList(obj), out);
            } else {
                JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts), out);
            }
        } else {
            JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts, filteredAgentAtts), out);
        }
    }

    private Map<String, ? extends Object> getFilteredMap(Map<String, Object> input) {
        return ServiceFactory.getAttributesService().filterEventAttributes(this.appName, input);
    }

    private Map<String, ? extends Object> getUserFilteredMap(Map<String, Object> input) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return this.getFilteredMap(input);
        }
        return Collections.emptyMap();
    }
}

