/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableList;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.service.module.JarInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class Jar
implements JSONStreamAware,
Cloneable {
    private final String name;
    private final JarInfo jarInfo;

    public Jar(String name, JarInfo jarInfo) {
        this.name = name;
        this.jarInfo = jarInfo;
    }

    protected String getName() {
        return this.name;
    }

    protected String getVersion() {
        return this.jarInfo.version;
    }

    public void writeJSONString(Writer pWriter) throws IOException {
        ImmutableList<Map<String, String>> toSend = ImmutableList.of(this.name, this.jarInfo.version, this.jarInfo.attributes);
        JSONArray.writeJSONString(toSend, pWriter);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Jar other = (Jar)obj;
        if (this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals(other.getVersion())) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

