/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.module.Jar;
import com.newrelic.agent.service.module.JarInfo;
import com.newrelic.agent.service.module.ShaChecksums;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarCollectorServiceProcessor {
    static final String JAR_EXTENSION = ".jar";
    static final String JAR_PROTOCOL = "jar";
    static final String UNKNOWN_VERSION = " ";
    private static final int MAX_MAP_SIZE = 1000;
    private static final JarInfo NON_JAR = new JarInfo(null, null);
    private static final JarInfo JAR_ERROR = new JarInfo(null, null);
    private final List<String> ignoreJars;
    private final Map<URL, JarInfo> sentJars;

    public JarCollectorServiceProcessor() {
        this(ServiceFactory.getConfigService().getDefaultAgentConfig().getIgnoreJars());
    }

    JarCollectorServiceProcessor(List<String> ignoreJars) {
        this.ignoreJars = ignoreJars;
        this.sentJars = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().build().asMap();
    }

    protected synchronized List<Jar> processModuleData(Collection<URL> urlsToProcess, boolean sendAll) {
        urlsToProcess = Sets.newHashSet(urlsToProcess);
        ArrayList<Jar> jars = Lists.newArrayList();
        if (sendAll) {
            urlsToProcess.addAll(this.sentJars.keySet());
        } else {
            urlsToProcess.removeAll(this.sentJars.keySet());
        }
        Map<URL, JarInfo> processedUrls = this.processUrls(urlsToProcess, jars);
        this.sentJars.putAll(processedUrls);
        return jars;
    }

    private Map<URL, JarInfo> processUrls(Collection<URL> urls, List<Jar> jars) {
        HashMap<URL, JarInfo> jarDetails = Maps.newHashMap();
        for (URL address : urls) {
            JarInfo jar = this.processUrl(address, jars);
            jarDetails.put(address, jar);
        }
        return jarDetails;
    }

    private JarInfo processUrl(URL url, List<Jar> jars) {
        try {
            if (!url.getFile().endsWith(JAR_EXTENSION)) {
                return NON_JAR;
            }
            Agent.LOG.log(Level.FINEST, "Processing file path {0}.", new Object[]{url.getFile()});
            return this.handleJar(url, jars);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Error processing the file path : {0}", new Object[]{e.getMessage()});
            return JAR_ERROR;
        }
    }

    private JarInfo handleJar(URL url, List<Jar> jars) {
        JarInfo jarInfo;
        try {
            jarInfo = JarCollectorServiceProcessor.getJarInfo(url);
            this.addJarAndVersion(url, jarInfo, jars);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Trouble getting version from {0} jar. Adding jar without version.", new Object[]{url.getFile()});
            jarInfo = new JarInfo(UNKNOWN_VERSION, ImmutableMap.<String, String>of());
            this.addJarAndVersion(url, jarInfo, jars);
        }
        return jarInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JarInfo getJarInfo(URL url) throws IOException {
        JarInfo jarInfo;
        JarInputStream jarFile;
        block11: {
            JarInfo jarInfo3;
            block10: {
                JarInfo jarInfo2;
                block9: {
                    HashMap<String, String> attributes = Maps.newHashMap();
                    try {
                        attributes.put("sha1Checksum", ShaChecksums.computeSha(url));
                    }
                    catch (Exception ex) {
                        Agent.LOG.log(Level.FINEST, ex, "{0}", new Object[]{ex.getMessage()});
                    }
                    jarFile = JarCollectorServiceProcessor.getJarInputStream(url);
                    try {
                        block8: {
                            try {
                                Map<String, String> pom = JarCollectorServiceProcessor.getPom(jarFile);
                                if (pom == null) break block8;
                                attributes.putAll(pom);
                                jarInfo2 = new JarInfo(pom.get("version"), attributes);
                            }
                            catch (Exception ex) {
                                Agent.LOG.log(Level.FINEST, ex, "{0}", new Object[]{ex.getMessage()});
                                break block8;
                            }
                            Object var6_9 = null;
                            break block9;
                        }
                        String version = JarCollectorServiceProcessor.getVersion(jarFile);
                        if (version == null) {
                            jarInfo3 = JarInfo.MISSING;
                            break block10;
                        }
                        jarInfo = new JarInfo(version, attributes);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_12 = null;
                        jarFile.close();
                        throw throwable;
                    }
                }
                jarFile.close();
                return jarInfo2;
            }
            Object var6_10 = null;
            jarFile.close();
            return jarInfo3;
        }
        Object var6_11 = null;
        jarFile.close();
        return jarInfo;
    }

    private static Map<String, String> getPom(JarInputStream jarFile) throws IOException {
        Properties pom = null;
        JarEntry entry = null;
        while ((entry = jarFile.getNextJarEntry()) != null) {
            if (!entry.getName().startsWith("META-INF/maven") || !entry.getName().endsWith("pom.properties")) continue;
            if (pom != null) {
                return null;
            }
            Properties props = new Properties();
            props.load(jarFile);
            pom = props;
        }
        return pom;
    }

    static String getVersion(JarInputStream jarFile) {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return null;
        }
        String version = JarCollectorServiceProcessor.getVersion(manifest.getMainAttributes());
        if (version == null && !manifest.getEntries().isEmpty()) {
            version = JarCollectorServiceProcessor.getVersion(manifest.getEntries().values().iterator().next());
        }
        return version;
    }

    static JarInputStream getJarInputStream(URL url) throws IOException {
        InputStream stream = url.openStream();
        if (stream instanceof JarInputStream) {
            return (JarInputStream)stream;
        }
        return new JarInputStream(stream);
    }

    private static String getVersion(Attributes attributes) {
        String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null && (version = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null) {
            version = attributes.getValue("Bundle-Version");
        }
        return version;
    }

    boolean addJarAndVersion(URL url, JarInfo jarInfo, List<Jar> jars) {
        if (jarInfo == null) {
            jarInfo = JarInfo.MISSING;
        }
        boolean added = false;
        String jarFile = null;
        try {
            jarFile = JarCollectorServiceProcessor.parseJarName(url);
            if (this.shouldAttemptAdd(jarFile)) {
                jars.add(new Jar(jarFile, jarInfo));
                added = true;
            }
        }
        catch (URISyntaxException e) {
            Agent.LOG.log(Level.FINEST, e, "{0}", new Object[]{e.getMessage()});
        }
        if (added) {
            Agent.LOG.log(Level.FINER, "Adding the jar {0} with version {1}.", new Object[]{jarFile, jarInfo.version});
        } else {
            Agent.LOG.log(Level.FINER, "Not taking version {0} for jar {1}.", new Object[]{jarInfo.version, jarFile});
        }
        return added;
    }

    static String parseJarName(URL url) throws URISyntaxException {
        int start;
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.toURI());
            return file.getName().trim();
        }
        Agent.LOG.log(Level.FINEST, "Parsing jar file name from {0}", new Object[]{url});
        String path = url.getFile();
        int end = path.lastIndexOf(JAR_EXTENSION);
        if (end > 0 && (start = (path = path.substring(0, end)).lastIndexOf(File.separator)) > 0) {
            return path.substring(start + 1) + JAR_EXTENSION;
        }
        throw new URISyntaxException(url.getPath(), "Unable to parse the jar file name from a URL");
    }

    private boolean shouldAttemptAdd(String jarFile) {
        return !this.ignoreJars.contains(jarFile);
    }
}

