/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.api.agent.Request;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtils {
    private static String SERVLET_EXCEPTION_CLASS_NAME = "javax.servlet.ServletException";
    public static final String NEWRELIC_IGNORE_ATTRIBUTE_NAME = "com.newrelic.agent.IGNORE";
    public static final String NEWRELIC_IGNORE_APDEX_ATTRIBUTE_NAME = "com.newrelic.agent.IGNORE_APDEX";
    public static final String APPLICATION_NAME_PARAM = "com.newrelic.agent.APPLICATION_NAME";
    public static final String TRANSACTION_NAME_PARAM = "com.newrelic.agent.TRANSACTION_NAME";

    private ServletUtils() {
    }

    public static Throwable getReportError(Throwable throwable) {
        if (throwable != null && SERVLET_EXCEPTION_CLASS_NAME.equals(throwable.getClass().getName())) {
            return StackTraces.getRootCause(throwable);
        }
        return throwable;
    }

    public static Map<String, String> getSimpleParameterMap(Map<String, String[]> parameterMap, int maxSizeLimit) {
        if (parameterMap == null || parameterMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            String value = ServletUtils.getValue(values, maxSizeLimit);
            if (value == null) continue;
            parameters.put(name, value);
        }
        return parameters;
    }

    public static void recordParameters(Transaction tx, Request request) {
        if (tx.isIgnore()) {
            return;
        }
        if (!ServiceFactory.getAttributesService().captureRequestParams(tx.getApplicationName())) {
            return;
        }
        Map<String, String> requestParameters = ServletUtils.getRequestParameterMap(request, tx.getAgentConfig().getMaxUserParameterSize());
        if (requestParameters.isEmpty()) {
            return;
        }
        tx.getPrefixedAgentAttributes().put("request.parameters.", requestParameters);
    }

    static Map<String, String> getRequestParameterMap(Request request, int maxSizeLimit) {
        Enumeration nameEnumeration = request.getParameterNames();
        if (nameEnumeration == null || !nameEnumeration.hasMoreElements()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        while (nameEnumeration.hasMoreElements()) {
            String name = nameEnumeration.nextElement().toString();
            if (name.length() > maxSizeLimit) {
                Agent.LOG.log(Level.FINER, "Rejecting request parameter with key \"{0}\" because the key is over the size limit of {1}", new Object[]{name, maxSizeLimit});
                continue;
            }
            String[] values = request.getParameterValues(name);
            String value = ServletUtils.getValue(values, maxSizeLimit);
            if (value == null) continue;
            requestParameters.put(name, value);
        }
        return requestParameters;
    }

    private static String getValue(String[] values, int maxSizeLimit) {
        String value;
        if (values == null || values.length == 0) {
            return null;
        }
        String string = value = values.length == 1 ? values[0] : Arrays.asList(values).toString();
        if (value != null && value.length() > maxSizeLimit) {
            value = values.length == 1 ? value.substring(0, maxSizeLimit) : value.substring(0, maxSizeLimit - 1) + ']';
        }
        return value;
    }
}

