/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.LazyMapImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTracer
extends AbstractTracer {
    protected static final int DEFAULT_TRACER_FLAGS = 6;
    private static final int INITIAL_PARAMETER_MAP_SIZE = 5;
    public static final MetricNameFormat NULL_METRIC_NAME_FORMATTER = new SimpleMetricNameFormat(null);
    public static final String BACKTRACE_PARAMETER_NAME = "backtrace";
    private final long startTime;
    private long duration;
    private long exclusiveDuration;
    private final Map<String, Object> parameters = new LazyMapImpl<String, Object>(5);
    private Tracer parentTracer;
    private Throwable throwable;
    private final ClassMethodSignature classMethodSignature;
    private Object invocationTarget;
    private MetricNameFormat metricNameFormat;
    private boolean isParent;
    private boolean childHasStackTrace;
    private final byte tracerFlags;

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags) {
        super(transaction);
        this.metricNameFormat = metricNameFormatter;
        this.classMethodSignature = sig;
        this.startTime = System.nanoTime();
        this.invocationTarget = object;
        this.parentTracer = transaction.getTransactionActivity().getLastTracer();
        if (!transaction.shouldGenerateTransactionSegment()) {
            tracerFlags &= 0xFFFFFFFB;
        }
        this.tracerFlags = (byte)tracerFlags;
    }

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
        this(transaction, sig, object, metricNameFormatter, 6);
    }

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object) {
        this(transaction, sig, object, NULL_METRIC_NAME_FORMATTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Throwable throwable) {
        this.throwable = throwable;
        if (!this.getTransaction().getTransactionState().finish(this.getTransaction(), this)) {
            return;
        }
        try {
            this.getTransactionActivity().lockTracerStart();
            this.doFinish(throwable);
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.WARNING, msg, t);
            } else {
                Agent.LOG.warning(msg);
            }
        }
        finally {
            this.getTransactionActivity().unlockTracerStart();
        }
        this.finish(191, null);
        if (Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINE, "(Debug) Tracer.finish(Throwable)");
        }
    }

    protected void reset() {
        this.invocationTarget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(int opcode, Object returnValue) {
        if (!this.getTransaction().getTransactionState().finish(this.getTransaction(), this)) {
            return;
        }
        this.duration = Math.max(0L, System.nanoTime() - this.getStartTime());
        this.exclusiveDuration += this.duration;
        if (this.exclusiveDuration < 0L || this.exclusiveDuration > this.duration) {
            String msg = MessageFormat.format("Invalid exclusive time {0} for tracer {1}", this.exclusiveDuration, this.getClass().getName());
            Agent.LOG.severe(msg);
            this.exclusiveDuration = this.duration;
        }
        try {
            String msg;
            block16: {
                this.getTransactionActivity().lockTracerStart();
                try {
                    if (191 != opcode) {
                        this.doFinish(opcode, returnValue);
                    }
                }
                catch (Throwable t) {
                    msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                    Agent.LOG.severe(msg);
                    Agent.LOG.log(Level.FINER, msg, t);
                }
                try {
                    this.attemptToStoreStackTrace();
                }
                catch (Throwable t) {
                    if (!Agent.LOG.isFinestEnabled()) break block16;
                    msg = MessageFormat.format("An error occurred getting stack trace for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                    Agent.LOG.log(Level.FINEST, msg, t);
                }
            }
            if (this.parentTracer != null) {
                this.parentTracer.childTracerFinished(this);
            }
            try {
                this.recordMetrics(this.getTransactionActivity().getTransactionStats());
            }
            catch (Throwable t) {
                msg = MessageFormat.format("An error occurred recording tracer metrics for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                Agent.LOG.severe(msg);
                Agent.LOG.log(Level.FINER, msg, t);
            }
            try {
                if (!(this instanceof SkipTracer)) {
                    this.getTransactionActivity().tracerFinished(this, opcode);
                }
            }
            catch (Throwable t) {
                msg = MessageFormat.format("An error occurred calling Transaction.tracerFinished() for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                Agent.LOG.severe(msg);
                Agent.LOG.log(Level.FINER, msg, t);
            }
            this.reset();
        }
        finally {
            this.getTransactionActivity().unlockTracerStart();
        }
    }

    protected void doFinish(Throwable throwable) {
    }

    protected void doFinish(int opcode, Object returnValue) {
    }

    protected boolean shouldStoreStackTrace() {
        return this.isTransactionSegment();
    }

    private void attemptToStoreStackTrace() {
        if (this.shouldStoreStackTrace()) {
            TransactionTracerConfig transactionTracerConfig = this.getTransaction().getTransactionTracerConfig();
            double stackTraceThresholdInNanos = transactionTracerConfig.getStackTraceThresholdInNanos();
            int stackTraceMax = transactionTracerConfig.getMaxStackTraces();
            if ((double)this.getDuration() > stackTraceThresholdInNanos && (this.childHasStackTrace || this.getTransaction().getTransactionCounts().getStackTraceCount() < stackTraceMax)) {
                this.storeStackTrace();
                if (!this.childHasStackTrace) {
                    this.getTransaction().getTransactionCounts().incrementStackTraceCount();
                    this.childHasStackTrace = true;
                }
            }
        }
    }

    public void storeStackTrace() {
        this.setParameter(BACKTRACE_PARAMETER_NAME, Thread.currentThread().getStackTrace());
    }

    public void setParameter(String key, Object value) {
        if (this.getTransaction().getTransactionCounts().isOverTracerSegmentLimit()) {
            return;
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        this.getTransaction().getTransactionCounts().incrementSize(DefaultTracer.sizeof(value));
        this.parameters.put(key, value);
    }

    static int sizeof(Object value) {
        int size = 0;
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof StackTraceElement) {
            StackTraceElement elem = (StackTraceElement)value;
            return DefaultTracer.sizeof(elem.getClassName()) + DefaultTracer.sizeof(elem.getFileName()) + DefaultTracer.sizeof(elem.getMethodName()) + 10;
        }
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                size += DefaultTracer.sizeof(obj);
            }
        }
        return size;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public long getRunningDurationInNanos() {
        return this.duration > 0L ? this.duration : Math.max(0L, System.nanoTime() - this.getStartTime());
    }

    @Override
    public long getDurationInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getExclusiveDuration() {
        return this.exclusiveDuration;
    }

    @Override
    public long getEndTime() {
        return this.getStartTime() + this.duration;
    }

    @Override
    public long getEndTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getEndTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getStartTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    protected final Object getInvocationTarget() {
        return this.invocationTarget;
    }

    @Override
    public Tracer getParentTracer() {
        return this.parentTracer;
    }

    @Override
    public void setParentTracer(Tracer tracer) {
        this.parentTracer = tracer;
    }

    public String getRequestMetricName() {
        return null;
    }

    public void setMetricNameFormat(MetricNameFormat nameFormat) {
        this.metricNameFormat = nameFormat;
    }

    protected final MetricNameFormat getMetricNameFormat() {
        return this.metricNameFormat;
    }

    @Override
    public final String getMetricName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getMetricName();
    }

    @Override
    public final String getTransactionSegmentName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentName();
    }

    @Override
    public final String getTransactionSegmentUri() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentUri();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    protected void recordMetrics(TransactionStats transactionStats) {
        if (this.getTransaction().isIgnore()) {
            return;
        }
        if (this.isMetricProducer()) {
            String metricName = this.getMetricName();
            if (metricName != null) {
                ResponseTimeStats stats = transactionStats.getScopedStats().getResponseTimeStats(metricName);
                stats.recordResponseTimeInNanos(this.getDuration(), this.getExclusiveDuration());
            }
            if (this.getRollupMetricNames() != null) {
                for (String name : this.getRollupMetricNames()) {
                    ResponseTimeStats stats = transactionStats.getUnscopedStats().getResponseTimeStats(name);
                    stats.recordResponseTimeInNanos(this.getDuration(), this.getExclusiveDuration());
                }
            }
            this.doRecordMetrics(transactionStats);
        }
    }

    protected void doRecordMetrics(TransactionStats transactionStats) {
    }

    @Override
    public final boolean isParent() {
        return this.isParent;
    }

    @Override
    public void childTracerFinished(Tracer child) {
        if (child.isMetricProducer() && !(child instanceof SkipTracer)) {
            this.exclusiveDuration -= child.getDuration();
            if (this.isTransactionSegment() && child.isTransactionSegment()) {
                this.isParent = true;
                if (child.isChildHasStackTrace()) {
                    this.childHasStackTrace = true;
                }
            }
        }
    }

    public void childTracerFinished(long childDurationInNanos) {
        this.exclusiveDuration -= childDurationInNanos;
    }

    @Override
    public ClassMethodSignature getClassMethodSignature() {
        return this.classMethodSignature;
    }

    @Override
    public final boolean isTransactionSegment() {
        return (this.tracerFlags & 4) == 4;
    }

    @Override
    public boolean isMetricProducer() {
        return (this.tracerFlags & 2) == 2;
    }

    @Override
    public final boolean isLeaf() {
        return (this.tracerFlags & 0x20) == 32;
    }

    @Override
    public boolean isChildHasStackTrace() {
        return this.childHasStackTrace;
    }

    @Override
    public TransactionSegment getTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(ttConfig, sqlObfuscator, startTime, this);
    }

    public void setMetricName(String ... metricNameParts) {
        String metricName = Strings.join('/', metricNameParts);
        this.setMetricNameFormat(new SimpleMetricNameFormat(metricName));
    }
}

