/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.jasper;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracerNoSkip;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.jasper.AbstractRUMState;
import com.newrelic.agent.tracers.jasper.GeneratorVisitTracerFactory;
import com.newrelic.agent.tracers.jasper.JasperClassFactory;
import com.newrelic.agent.tracers.jasper.Node;
import com.newrelic.agent.tracers.jasper.Visitor;
import java.util.logging.Level;

public class GeneratorVisitBodyTracerFactory
implements TracerFactory {
    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object visitorObj, Object[] args) {
        if (!GeneratorVisitTracerFactory.isAutoInstrumentationEnabled()) {
            return null;
        }
        try {
            String page = GeneratorVisitTracerFactory.getPage(transaction);
            if (GeneratorVisitTracerFactory.isIgnorePageForAutoInstrument(page, transaction)) {
                return null;
            }
            JasperClassFactory factory = JasperClassFactory.getJasperClassFactory(visitorObj.getClass().getClassLoader());
            Node node = factory.getNode(args[0]);
            final Visitor visitor = factory.getVisitor(visitorObj);
            String nodeName = node.getQName();
            if ("head".equals(nodeName.toLowerCase()) && this.checkParentNode(node, "html")) {
                Agent.LOG.fine("Compiling the browser timing header into a jsp");
                visitor.writeScriptlet(AbstractRUMState.BROWSER_TIMING_HEADER_CODE_SNIPPET);
            } else if ("body".equals(nodeName.toLowerCase()) && this.checkParentNode(node, "html")) {
                return new MethodExitTracerNoSkip(sig, transaction){

                    protected void doFinish(int opcode, Object returnValue) {
                        GeneratorVisitBodyTracerFactory.this.writeFooter(visitor);
                    }
                };
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "An error occurred auto enabling real user monitoring", e);
        }
        return null;
    }

    private void writeFooter(Visitor visitor) {
        Agent.LOG.fine("Compiling the browser timing footer into a jsp");
        try {
            visitor.writeScriptlet(AbstractRUMState.BROWSER_TIMING_FOOTER_CODE_SNIPPET);
        }
        catch (Exception ex) {
            Agent.LOG.log(Level.FINE, "An error occurred auto enabling real user monitoring", ex);
        }
    }

    private boolean checkParentNode(Node node, String name) throws Exception {
        Node parent = node.getParent();
        if (parent != null) {
            return name.equals(parent.getQName());
        }
        return false;
    }
}

