/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.transport.DataSender;
import com.newrelic.agent.transport.DataSenderImpl;
import com.newrelic.agent.transport.IDataSenderFactory;

public class DataSenderFactory {
    private static volatile IDataSenderFactory DATA_SENDER_FACTORY = new DefaultDataSenderFactory();

    private DataSenderFactory() {
    }

    public static void setDataSenderFactory(IDataSenderFactory dataSenderFactory) {
        if (dataSenderFactory == null) {
            return;
        }
        DATA_SENDER_FACTORY = dataSenderFactory;
    }

    public static IDataSenderFactory getDataSenderFactory() {
        return DATA_SENDER_FACTORY;
    }

    public static DataSender create(AgentConfig config) {
        return DATA_SENDER_FACTORY.create(config);
    }

    private static class DefaultDataSenderFactory
    implements IDataSenderFactory {
        private DefaultDataSenderFactory() {
        }

        public DataSender create(AgentConfig config) {
            return new DataSenderImpl(config);
        }
    }
}

