/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.JarResource;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.util.Streams;
import com.newrelic.agent.util.asm.ClassStructure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotations {
    private Annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Class<?>> getAnnotationClasses(Class<?> annotationClass, String packageSearchPath) {
        ArrayList arrayList;
        String pointcutAnnotation = 'L' + annotationClass.getName().replace('.', '/') + ';';
        if (!packageSearchPath.endsWith("/")) {
            packageSearchPath = packageSearchPath + "/";
        }
        Pattern pattern = Pattern.compile(packageSearchPath + "(.*).class");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        JarResource agentJarFile = AgentJarHelper.getAgentJarResource();
        try {
            Collection<String> fileNames = AgentJarHelper.findAgentJarFileNames(pattern);
            ArrayList classes = new ArrayList(fileNames.size());
            for (String fileName : fileNames) {
                int size = (int)agentJarFile.getSize(fileName);
                ByteArrayOutputStream out = new ByteArrayOutputStream(size);
                try {
                    Streams.copy(agentJarFile.getInputStream(fileName), (OutputStream)out, true);
                    ClassReader cr = new ClassReader(out.toByteArray());
                    ClassStructure structure = ClassStructure.getClassStructure(cr, 4);
                    Set<String> annotations = structure.getClassAnnotations().keySet();
                    if (!annotations.contains(pointcutAnnotation)) continue;
                    String className = fileName.replace('/', '.');
                    int index = className.indexOf(".class");
                    if (index > 0) {
                        className = className.substring(0, index);
                    }
                    Class<?> clazz = classLoader.loadClass(className);
                    classes.add(clazz);
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINEST, e, e.toString(), new Object[0]);
                }
            }
            arrayList = classes;
            Object var19_19 = null;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            try {
                agentJarFile.close();
            }
            catch (IOException e) {
                Agent.LOG.log(Level.FINEST, e, e.toString(), new Object[0]);
            }
            throw throwable;
        }
        try {
            agentJarFile.close();
        }
        catch (IOException e) {
            Agent.LOG.log(Level.FINEST, e, e.toString(), new Object[0]);
        }
        return arrayList;
    }
}

