/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertOnlyArray<E> {
    private volatile Object[] elements;
    private int size = 0;

    public InsertOnlyArray(int capacity) {
        this.elements = new Object[capacity];
    }

    public E get(int index) {
        return (E)this.elements[index];
    }

    public int getIndex(E element) {
        Object[] arr = this.elements;
        for (int i = 0; i < arr.length; ++i) {
            if (!element.equals(arr[i])) continue;
            return i;
        }
        return -1;
    }

    public synchronized int add(E newElement) {
        int position = this.size;
        if (this.size + 1 > this.elements.length) {
            this.grow(this.size + 1);
        }
        this.elements[position] = newElement;
        ++this.size;
        return position;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        newCapacity = Math.max(newCapacity, minCapacity);
        this.elements = Arrays.copyOf(this.elements, newCapacity);
    }
}

