/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.attributes.CustomAttributeSender;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.PublicApi;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.dispatchers.WebRequestDispatcher;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRelicApiImplementation
implements PublicApi {
    private final AttributeSender attributeSender = new CustomAttributeSender();

    public void noticeError(Throwable throwable, Map<String, String> params) {
        try {
            ErrorService.reportException(throwable, NewRelicApiImplementation.filtorErrorAtts(params, this.attributeSender));
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", throwable);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", throwable, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    public void noticeError(Throwable throwable) {
        Map<String, String> params = Collections.emptyMap();
        this.noticeError(throwable, params);
    }

    public void noticeError(String message, Map<String, String> params) {
        try {
            ErrorService.reportError(message, NewRelicApiImplementation.filtorErrorAtts(params, this.attributeSender));
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", message);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", message, t);
            NewRelicApiImplementation.logException(msg, t);
        }
    }

    private static Map<String, String> filtorErrorAtts(Map<String, String> params, AttributeSender attributeSender) {
        TreeMap<String, String> atts = new TreeMap<String, String>();
        if (params != null) {
            int maxErrorCount = NewRelicApiImplementation.getNumberOfErrorAttsLeft();
            for (Map.Entry<String, String> current : params.entrySet()) {
                if (atts.size() >= maxErrorCount) {
                    Agent.LOG.log(Level.FINER, "Unable to add custom attribute for key \"{0}\" because the limit on error attributes has been reached.", new Object[]{current.getKey()});
                    continue;
                }
                Object value = attributeSender.verifyParameterAndReturnValue(current.getKey(), current.getValue(), "noticeError");
                if (value == null) continue;
                atts.put(current.getKey(), (String)value);
            }
        }
        return atts;
    }

    private static int getNumberOfErrorAttsLeft() {
        Transaction tx = Transaction.getTransaction();
        return tx.getAgentConfig().getMaxUserParameters() - tx.getErrorAttributes().size();
    }

    public void noticeError(String message) {
        Map<String, String> params = Collections.emptyMap();
        this.noticeError(message, params);
    }

    public void addCustomParameter(String key, String value) {
        this.attributeSender.addAttribute(key, value);
    }

    public void addCustomParameter(String key, Number value) {
        this.attributeSender.addAttribute(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionName(String category, String name) {
        TransactionNamePriority namePriority;
        Transaction tx;
        Dispatcher dispatcher;
        if (Strings.isEmpty(category)) {
            category = "Custom";
        }
        if (name == null || name.length() == 0) {
            Agent.LOG.log(Level.FINER, "Unable to set the transaction name to an empty string");
            return;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((dispatcher = (tx = Transaction.getTransaction().getRootTransaction()).getDispatcher()) == null) {
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the transaction name to \"{0}\" in NewRelic API - no transaction", name));
            }
            return;
        }
        boolean isWebTransaction = dispatcher.isWebTransaction();
        TransactionNamingPolicy policy = TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy();
        TransactionNamePriority transactionNamePriority = namePriority = "Uri".equals(category) ? TransactionNamePriority.REQUEST_URI : TransactionNamePriority.CUSTOM_HIGH;
        if (Agent.LOG.isLoggable(Level.FINER)) {
            if (policy.canSetTransactionName(tx, namePriority)) {
                String msg = MessageFormat.format("Setting {1} transaction name to \"{0}\" in NewRelic API", name, isWebTransaction ? "web" : "background");
                Agent.LOG.finer(msg);
            } else {
                Agent.LOG.finer("Unable to set the transaction name to " + name);
            }
        }
        Transaction transaction = tx;
        synchronized (transaction) {
            policy.setTransactionName(tx, name, category, namePriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreTransaction() {
        Transaction tx;
        Transaction transaction = tx = Transaction.getTransaction().getRootTransaction();
        synchronized (transaction) {
            tx.setIgnore(true);
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer("Set ignore transaction in NewRelic API");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreApdex() {
        Transaction tx;
        Transaction transaction = tx = Transaction.getTransaction().getRootTransaction();
        synchronized (transaction) {
            tx.ignoreApdex();
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer("Set ignore APDEX in NewRelic API");
        }
    }

    public void setRequestAndResponse(Request request, Response response) {
        Transaction tx = Transaction.getTransaction();
        WebRequestDispatcher dispatcher = new WebRequestDispatcher(request, response, tx);
        tx.setDispatcher(dispatcher);
        Agent.LOG.finest("Custom request dispatcher registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBrowserTimingHeaderForContentType(String contentType) {
        Transaction tx = null;
        try {
            if (!Transaction.hasTransaction()) {
                Agent.LOG.finer("Unable to inject browser timing header in a JSP: not running in a transaction");
                return "";
            }
            tx = Transaction.getTransaction().getRootTransaction();
            String header = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                header = tx.getBeaconTransactionState().getBrowserTimingHeaderForJsp();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing header in a JSP: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error injecting browser timing header in a JSP: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrowserTimingHeader() {
        Transaction tx = null;
        try {
            if (!Transaction.hasTransaction()) {
                Agent.LOG.finer("Unable to get browser timing header in NewRelic API: not running in a transaction");
                return "";
            }
            tx = Transaction.getTransaction().getRootTransaction();
            String header = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                header = tx.getBeaconTransactionState().getBrowserTimingHeader();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing header in NewRelic API: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting browser timing header in NewRelic API: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBrowserTimingFooterForContentType(String contentType) {
        Transaction tx = null;
        try {
            if (!Transaction.hasTransaction()) {
                Agent.LOG.finer("Unable to inject browser timing footer in a JSP: not running in a transaction");
                return "";
            }
            tx = Transaction.getTransaction().getRootTransaction();
            String footer = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                footer = tx.getBeaconTransactionState().getBrowserTimingFooter();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing footer in a JSP: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error injecting browser timing footer in a JSP: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrowserTimingFooter() {
        Transaction tx = null;
        try {
            if (!Transaction.hasTransaction()) {
                Agent.LOG.finer("Unable to get browser timing footer in NewRelic API: not running in a transaction");
                return "";
            }
            tx = Transaction.getTransaction().getRootTransaction();
            String footer = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                footer = tx.getBeaconTransactionState().getBrowserTimingFooter();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing footer in NewRelic API: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting browser timing footer in NewRelic API: {0}", t);
            NewRelicApiImplementation.logException(msg, t);
            return "";
        }
    }

    public void setUserName(String name) {
        Transaction tx = Transaction.getTransaction().getRootTransaction();
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Attepmting to set user name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
        this.addCustomParameter("user", name);
    }

    public void setAccountName(String name) {
        Transaction tx = Transaction.getTransaction().getRootTransaction();
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Attepmting to set account name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
        this.addCustomParameter("account", name);
    }

    public void setProductName(String name) {
        Transaction tx = Transaction.getTransaction().getRootTransaction();
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Attepmting to set product name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
        this.addCustomParameter("product", name);
    }

    private static void logException(String msg, Throwable t) {
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            Agent.LOG.log(Level.FINEST, msg, t);
        } else if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer(msg);
        }
    }

    public static void initialize() {
        AgentBridge.publicApi = new NewRelicApiImplementation();
    }
}

