/* 
 * This file is part of the Echo Web Application Framework (hereinafter "Echo").
 * Copyright (C) 2002-2009 NextApp, Inc.
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 */

package nextapp.echo.app.serial.property;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.Serializer;
import nextapp.echo.app.util.Context;

/**
 * <code>SerialPropertyPeer</code> for <code>Map</code> properties.
 */
public class MapPeer 
implements SerialPropertyPeer {

    /**
     * @see nextapp.echo.app.serial.SerialPropertyPeer#toProperty(nextapp.echo.app.util.Context,
     *     java.lang.Class, org.w3c.dom.Element)
     */
    public Object toProperty(Context context, Class objectClass, Element propertyElement) 
    throws SerialException {
        SerialContext serialContext = (SerialContext) context.get(SerialContext.class);
        Serializer serializer = Serializer.forClassLoader(serialContext.getClassLoader());
        
        Map map = new HashMap();
        Node childNode = propertyElement.getFirstChild();
        while (childNode != null) {
            if (childNode instanceof Element && "p".equals(childNode.getNodeName())) {
                Element childPropertyElement = (Element) childNode;
                SerialPropertyPeer peer = serializer.getSerialPropertyPeer(childPropertyElement);
                if (peer != null) {
                    String name = childPropertyElement.getAttribute("n");
                    Object value = peer.toProperty(context, null, childPropertyElement);
                    map.put(name, value);
                }
            }
            childNode = childNode.getNextSibling();
        }
        return map;
    }

    /**
     * @see nextapp.echo.app.serial.SerialPropertyPeer#toXml(nextapp.echo.app.util.Context, 
     *      java.lang.Class, org.w3c.dom.Element, java.lang.Object)
     */
    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) 
    throws SerialException {
        SerialContext serialContext = (SerialContext) context.get(SerialContext.class);
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory) context.get(PropertyPeerFactory.class);
        propertyElement.setAttribute("t", "m");
        Map map = (Map) propertyValue;
        Iterator keyIt = map.keySet().iterator();
        while (keyIt.hasNext()) {
            String key = keyIt.next().toString();
            Object value = map.get(key);
            if (value == null) {
                continue;
            } 
            Class propertyClass = value.getClass();
            SerialPropertyPeer peer = propertyPeerFactory.getPeerForProperty(propertyClass);
            Element element = serialContext.getDocument().createElement("p");
            element.setAttribute("n", key);
            peer.toXml(context, propertyClass, element, value);
            propertyElement.appendChild(element);
        }
    }
}
