/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.io.Serializable;

public class Alignment
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    public static final Alignment ALIGN_LEFT = new Alignment(3, 0);
    public static final Alignment ALIGN_CENTER = new Alignment(4, 0);
    public static final Alignment ALIGN_RIGHT = new Alignment(5, 0);
    public static final Alignment ALIGN_TOP = new Alignment(0, 6);
    public static final Alignment ALIGN_BOTTOM = new Alignment(0, 7);
    public static final int DEFAULT = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int LEFT = 3;
    public static final int CENTER = 4;
    public static final int RIGHT = 5;
    public static final int TOP = 6;
    public static final int BOTTOM = 7;
    private int horizontal;
    private int vertical;

    public Alignment(int horizontal, int vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Alignment)) {
            return false;
        }
        Alignment that = (Alignment)o;
        return this.horizontal == that.horizontal && this.vertical == that.vertical;
    }

    public int getHorizontal() {
        return this.horizontal;
    }

    public int getVertical() {
        return this.vertical;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("h:");
        switch (this.horizontal) {
            case 0: {
                out.append("default");
                break;
            }
            case 1: {
                out.append("leading");
                break;
            }
            case 2: {
                out.append("trailing");
                break;
            }
            case 3: {
                out.append("left");
                break;
            }
            case 4: {
                out.append("center");
                break;
            }
            case 5: {
                out.append("right");
                break;
            }
            default: {
                out.append("(invalid)");
            }
        }
        out.append(",v:");
        switch (this.vertical) {
            case 0: {
                out.append("default");
                break;
            }
            case 6: {
                out.append("top");
                break;
            }
            case 4: {
                out.append("center");
                break;
            }
            case 7: {
                out.append("bottom");
                break;
            }
            default: {
                out.append("(invalid)");
            }
        }
        return out.toString();
    }
}

