/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;

public class AwtImageReference
implements ImageReference {
    private static final long serialVersionUID = 20070101L;
    private transient Image image;
    private String id;

    public AwtImageReference() {
        this(null);
    }

    public AwtImageReference(Image image) {
        this.image = image;
        this.id = ApplicationInstance.generateSystemId();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AwtImageReference)) {
            return false;
        }
        AwtImageReference that = (AwtImageReference)o;
        return this.image == that.image || this.image != null && this.image.equals(that.image);
    }

    public Extent getHeight() {
        if (this.image == null) {
            return null;
        }
        int height = this.image.getHeight(null);
        if (height > 0) {
            return new Extent(height, 1);
        }
        return null;
    }

    public String getRenderId() {
        return this.id;
    }

    public Image getImage() {
        return this.image;
    }

    public Extent getWidth() {
        if (this.image == null) {
            return null;
        }
        int width = this.image.getWidth(null);
        if (width > 0) {
            return new Extent(width, 1);
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int width = in.readInt();
        int height = in.readInt();
        int[] pixels = (int[])in.readObject();
        if (pixels != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ColorModel colorModel = ColorModel.getRGBdefault();
            this.image = toolkit.createImage(new MemoryImageSource(width, height, colorModel, pixels, 0, width));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        out.writeInt(width);
        out.writeInt(height);
        if (this.image == null) {
            out.writeObject(null);
        } else {
            int[] pixels = new int[width * height];
            try {
                PixelGrabber pg = new PixelGrabber(this.image, 0, 0, width, height, pixels, 0, width);
                pg.grabPixels();
                if ((pg.getStatus() & 0x80) != 0) {
                    throw new IOException("Unable to serialize java.awt.image: PixelGrabber aborted.");
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Unable to serialize java.awt.Image: PixelGrabber interrupted.");
            }
            out.writeObject(pixels);
        }
    }
}

