/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import nextapp.echo.app.Border;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Insets;

public class Grid
extends Component {
    private static final long serialVersionUID = 20070101L;
    public static final int DEFAULT_SIZE = 2;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_COLUMN_WIDTH = "columnWidth";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_ROW_HEIGHT = "rowHeight";
    public static final String PROPERTY_SIZE = "size";
    public static final String PROPERTY_WIDTH = "width";

    public Grid() {
    }

    public Grid(int size) {
        this.setSize(size);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public Extent getColumnWidth(int columnIndex) {
        return (Extent)this.getIndex(PROPERTY_COLUMN_WIDTH, columnIndex);
    }

    public Extent getHeight() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public int getOrientation() {
        Integer orientationValue = (Integer)this.get(PROPERTY_ORIENTATION);
        return orientationValue == null ? 0 : orientationValue;
    }

    public Extent getRowHeight(int rowIndex) {
        return (Extent)this.getIndex(PROPERTY_ROW_HEIGHT, rowIndex);
    }

    public int getSize() {
        Integer sizeValue = (Integer)this.get(PROPERTY_SIZE);
        if (sizeValue == null) {
            return 2;
        }
        return sizeValue;
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setColumnWidth(int columnIndex, Extent newValue) {
        this.setIndex(PROPERTY_COLUMN_WIDTH, columnIndex, newValue);
    }

    public void setHeight(Extent newValue) {
        this.set(PROPERTY_HEIGHT, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setOrientation(int newValue) {
        this.set(PROPERTY_ORIENTATION, new Integer(newValue));
    }

    public void setRowHeight(int rowIndex, Extent newValue) {
        this.setIndex(PROPERTY_ROW_HEIGHT, rowIndex, newValue);
    }

    public void setSize(int newValue) {
        this.set(PROPERTY_SIZE, new Integer(newValue));
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }
}

