/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Pane;
import nextapp.echo.app.PaneContainer;

public class SplitPane
extends Component
implements Pane,
PaneContainer {
    private static final long serialVersionUID = 20070101L;
    public static final int ORIENTATION_HORIZONTAL_LEADING_TRAILING = 0;
    public static final int ORIENTATION_HORIZONTAL_TRAILING_LEADING = 1;
    public static final int ORIENTATION_HORIZONTAL_LEFT_RIGHT = 2;
    public static final int ORIENTATION_HORIZONTAL_RIGHT_LEFT = 3;
    public static final int ORIENTATION_VERTICAL_TOP_BOTTOM = 4;
    public static final int ORIENTATION_VERTICAL_BOTTOM_TOP = 5;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 4;
    public static final String PROPERTY_AUTO_POSITIONED = "autoPositioned";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_RESIZABLE = "resizable";
    public static final String PROPERTY_SEPARATOR_COLOR = "separatorColor";
    public static final String PROPERTY_SEPARATOR_HEIGHT = "separatorHeight";
    public static final String PROPERTY_SEPARATOR_HORIZONTAL_IMAGE = "separatorHorizontalImage";
    public static final String PROPERTY_SEPARATOR_HORIZONTAL_ROLLOVER_IMAGE = "separatorHorizontalRolloverImage";
    public static final String PROPERTY_SEPARATOR_POSITION = "separatorPosition";
    public static final String PROPERTY_SEPARATOR_ROLLOVER_COLOR = "separatorRolloverColor";
    public static final String PROPERTY_SEPARATOR_WIDTH = "separatorWidth";
    public static final String PROPERTY_SEPARATOR_VERTICAL_IMAGE = "separatorVerticalImage";
    public static final String PROPERTY_SEPARATOR_VERTICAL_ROLLOVER_IMAGE = "separatorVerticalRolloverImage";
    public static final String PROPERTY_SEPARATOR_VISIBLE = "separatorVisible";

    public SplitPane() {
    }

    public SplitPane(int orientation) {
        this.setOrientation(orientation);
    }

    public SplitPane(int orientation, boolean autoPositioned) {
        this.setOrientation(orientation);
        this.setAutoPositioned(autoPositioned);
    }

    public SplitPane(int orientation, Extent separatorPosition) {
        this.setOrientation(orientation);
        if (separatorPosition != null) {
            this.setSeparatorPosition(separatorPosition);
        }
    }

    public int getOrientation() {
        Integer orientation = (Integer)this.get(PROPERTY_ORIENTATION);
        return orientation == null ? 4 : orientation;
    }

    public Color getSeparatorColor() {
        return (Color)this.get(PROPERTY_SEPARATOR_COLOR);
    }

    public Extent getSeparatorHeight() {
        return (Extent)this.get(PROPERTY_SEPARATOR_HEIGHT);
    }

    public FillImage getSeparatorHorizontalImage() {
        return (FillImage)this.get(PROPERTY_SEPARATOR_HORIZONTAL_IMAGE);
    }

    public FillImage getSeparatorHorizontalRolloverImage() {
        return (FillImage)this.get(PROPERTY_SEPARATOR_HORIZONTAL_ROLLOVER_IMAGE);
    }

    public Extent getSeparatorPosition() {
        return (Extent)this.get(PROPERTY_SEPARATOR_POSITION);
    }

    public Color getSeparatorRolloverColor() {
        return (Color)this.get(PROPERTY_SEPARATOR_ROLLOVER_COLOR);
    }

    public FillImage getSeparatorVerticalImage() {
        return (FillImage)this.get(PROPERTY_SEPARATOR_VERTICAL_IMAGE);
    }

    public FillImage getSeparatorVerticalRolloverImage() {
        return (FillImage)this.get(PROPERTY_SEPARATOR_VERTICAL_ROLLOVER_IMAGE);
    }

    public Extent getSeparatorWidth() {
        return (Extent)this.get(PROPERTY_SEPARATOR_WIDTH);
    }

    public boolean isAutoPositioned() {
        Boolean value = (Boolean)this.get(PROPERTY_AUTO_POSITIONED);
        return value == null ? false : value;
    }

    public boolean isResizable() {
        Boolean value = (Boolean)this.get(PROPERTY_RESIZABLE);
        return value == null ? false : value;
    }

    public boolean isSeparatorVisible(boolean newValue) {
        Boolean value = (Boolean)this.get(PROPERTY_SEPARATOR_VISIBLE);
        return value == null ? true : value;
    }

    public boolean isValidChild(Component component) {
        return this.getComponentCount() <= 1;
    }

    public boolean isValidParent(Component parent) {
        return parent instanceof PaneContainer;
    }

    public void processInput(String inputName, Object inputValue) {
        if (PROPERTY_SEPARATOR_POSITION.equals(inputName)) {
            this.setSeparatorPosition((Extent)inputValue);
        }
    }

    public void setAutoPositioned(boolean newValue) {
        this.set(PROPERTY_AUTO_POSITIONED, new Boolean(newValue));
    }

    public void setOrientation(int newValue) {
        this.set(PROPERTY_ORIENTATION, new Integer(newValue));
    }

    public void setResizable(boolean newValue) {
        this.set(PROPERTY_RESIZABLE, new Boolean(newValue));
    }

    public void setSeparatorVisible(boolean newValue) {
        this.set(PROPERTY_SEPARATOR_VISIBLE, new Boolean(newValue));
    }

    public void setSeparatorColor(Color newValue) {
        this.set(PROPERTY_SEPARATOR_COLOR, newValue);
    }

    public void setSeparatorHeight(Extent newValue) {
        this.set(PROPERTY_SEPARATOR_HEIGHT, newValue);
    }

    public void setSeparatorHorizontalImage(FillImage newValue) {
        this.set(PROPERTY_SEPARATOR_HORIZONTAL_IMAGE, newValue);
    }

    public void setSeparatorHorizontalRolloverImage(FillImage newValue) {
        this.set(PROPERTY_SEPARATOR_HORIZONTAL_ROLLOVER_IMAGE, newValue);
    }

    public void setSeparatorPosition(Extent newValue) {
        if (newValue != null && newValue.getValue() < 0) {
            throw new IllegalArgumentException("Extent value may not be negative.");
        }
        this.set(PROPERTY_SEPARATOR_POSITION, newValue);
    }

    public void setSeparatorRolloverColor(Color newValue) {
        this.set(PROPERTY_SEPARATOR_ROLLOVER_COLOR, newValue);
    }

    public void setSeparatorVerticalImage(FillImage newValue) {
        this.set(PROPERTY_SEPARATOR_VERTICAL_IMAGE, newValue);
    }

    public void setSeparatorVerticalRolloverImage(FillImage newValue) {
        this.set(PROPERTY_SEPARATOR_VERTICAL_ROLLOVER_IMAGE, newValue);
    }

    public void setSeparatorWidth(Extent newValue) {
        this.set(PROPERTY_SEPARATOR_WIDTH, newValue);
    }
}

