/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import nextapp.echo.app.Component;
import nextapp.echo.extras.app.event.DropEvent;
import nextapp.echo.extras.app.event.DropListener;

public class DragSource
extends Component {
    public static final String DROP_LISTENERS_CHANGED_PROPERTY = "dropListeners";
    public static final String DROP_TARGETS_CHANGED_PROPERTY = "dropTargets";
    public static final String INPUT_DROP = "drop";
    private List dropTargetIdList = new ArrayList();

    public DragSource() {
    }

    public DragSource(Component draggable) {
        this.add(draggable);
    }

    public void addDropTarget(String dropTargetId) {
        if (this.dropTargetIdList.indexOf(dropTargetId) != -1) {
            return;
        }
        if (dropTargetId == null) {
            throw new IllegalArgumentException("Cannot add null drop target id.");
        }
        this.dropTargetIdList.add(dropTargetId);
        this.firePropertyChange(DROP_TARGETS_CHANGED_PROPERTY, null, dropTargetId);
    }

    public void addDropListener(DropListener listener) {
        this.getEventListenerList().addListener(DropListener.class, (EventListener)listener);
        this.firePropertyChange(DROP_LISTENERS_CHANGED_PROPERTY, null, listener);
    }

    private void fireDropEvent(DropEvent event) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(DropListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            DropListener listener = (DropListener)listeners[i];
            listener.dropPerformed(event);
        }
    }

    public String getDropTarget(int index) {
        return (String)this.dropTargetIdList.get(index);
    }

    public int getDropTargetCount() {
        return this.dropTargetIdList.size();
    }

    public boolean hasDropListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(DropListener.class) > 0;
    }

    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if (INPUT_DROP.equals(name)) {
            Component specificComponent;
            Component targetComponent;
            for (targetComponent = specificComponent = (Component)value; targetComponent != null && this.dropTargetIdList.indexOf(targetComponent.getRenderId()) == -1; targetComponent = targetComponent.getParent()) {
            }
            if (targetComponent == null) {
                return;
            }
            this.fireDropEvent(new DropEvent((Object)this, targetComponent, specificComponent));
        }
    }

    public void removeAllDropTargets() {
        this.dropTargetIdList.clear();
        this.firePropertyChange(DROP_TARGETS_CHANGED_PROPERTY, null, null);
    }

    public void removeDropTarget(String dropTargetId) {
        if (this.dropTargetIdList.remove(dropTargetId)) {
            this.firePropertyChange(DROP_TARGETS_CHANGED_PROPERTY, dropTargetId, null);
        }
    }

    public void removeDropListener(DropListener listener) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(DropListener.class, (EventListener)listener);
        this.firePropertyChange(DROP_LISTENERS_CHANGED_PROPERTY, listener, null);
    }
}

