/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import java.util.EventListener;
import java.util.Map;
import nextapp.echo.app.Border;
import nextapp.echo.app.Component;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.event.DocumentEvent;
import nextapp.echo.app.event.DocumentListener;
import nextapp.echo.app.text.Document;
import nextapp.echo.app.text.StringDocument;
import nextapp.echo.extras.app.event.RichTextOperationEvent;
import nextapp.echo.extras.app.event.RichTextOperationListener;

public class RichTextArea
extends Component {
    public static final String ICON_ALIGNMENT = "alignment";
    public static final String ICON_ALIGNMENT_CENTER = "alignmentCenter";
    public static final String ICON_ALIGNMENT_JUSTIFY = "alignmentJustify";
    public static final String ICON_ALIGNMENT_LEFT = "alignmentLeft";
    public static final String ICON_ALIGNMENT_RIGHT = "alignmentRight";
    public static final String ICON_BACKGROUND = "background";
    public static final String ICON_BOLD = "bold";
    public static final String ICON_BULLETED_LIST = "bulletedList";
    public static final String ICON_CANCEL = "cancel";
    public static final String ICON_COPY = "copy";
    public static final String ICON_CUT = "cut";
    public static final String ICON_DELETE = "delete";
    public static final String ICON_FOREGROUND = "foreground";
    public static final String ICON_FORMAT_PARAGRAPH_STYLE = "paragraphStyle";
    public static final String ICON_FORMAT_TEXT_STYLE = "textStyle";
    public static final String ICON_HORIZONTAL_RULE = "horizontalRule";
    public static final String ICON_HYPERLINK = "hyperlink";
    public static final String ICON_IMAGE = "image";
    public static final String ICON_INDENT = "indent";
    public static final String ICON_ITALIC = "italic";
    public static final String ICON_NUMBERED_LIST = "numberedList";
    public static final String ICON_OK = "ok";
    public static final String ICON_OUTDENT = "outdent";
    public static final String ICON_PARAGRAPH_STYLE_HEADING_1 = "styleH1";
    public static final String ICON_PARAGRAPH_STYLE_HEADING_2 = "styleH2";
    public static final String ICON_PARAGRAPH_STYLE_HEADING_3 = "styleH3";
    public static final String ICON_PARAGRAPH_STYLE_HEADING_4 = "styleH4";
    public static final String ICON_PARAGRAPH_STYLE_HEADING_5 = "styleH5";
    public static final String ICON_PARAGRAPH_STYLE_HEADING_6 = "styleH6";
    public static final String ICON_PARAGRAPH_STYLE_NORMAL = "styleNormal";
    public static final String ICON_PARAGRAPH_STYLE_PREFORMATTED = "stylePreformatted";
    public static final String ICON_PASTE = "paste";
    public static final String ICON_PLAIN_TEXT = "plainText";
    public static final String ICON_REDO = "redo";
    public static final String ICON_SELECT_ALL = "selectAll";
    public static final String ICON_STRIKETHROUGH = "strikethrough";
    public static final String ICON_SUBSCRIPT = "subscript";
    public static final String ICON_SUPERSCRIPT = "superscript";
    public static final String ICON_TABLE = "table";
    public static final String ICON_TABLE_COLUMN_DELETE = "tableDeleteColumn";
    public static final String ICON_TABLE_COLUMN_INSERT = "tableInsertColumn";
    public static final String ICON_TABLE_ROW_DELETE = "tableDeleteRow";
    public static final String ICON_TABLE_ROW_INSERT = "tableInsertRow";
    public static final String ICON_UNDERLINE = "underline";
    public static final String ICON_UNDO = "undo";
    public static final String FEATURE_MENU = "menu";
    public static final String FEATURE_TOOLBAR = "toolbar";
    public static final String FEATURE_UNDO = "undo";
    public static final String FEATURE_CLIPBOARD = "clipboard";
    public static final String FEATURE_ALIGNMENT = "alignment";
    public static final String FEATURE_FOREGROUND = "foreground";
    public static final String FEATURE_BACKGROUND = "background";
    public static final String FEATURE_LIST = "list";
    public static final String FEATURE_BULLETED_LIST = "bulletedList";
    public static final String FEATURE_NUMBERED_LIST = "numberedList";
    public static final String FEATURE_TABLE = "table";
    public static final String FEATURE_IMAGE = "image";
    public static final String FEATURE_HORIZONTAL_RULE = "horizontalRule";
    public static final String FEATURE_HYPERLINK = "hyperlink";
    public static final String FEATURE_SUBSCRIPT = "subscript";
    public static final String FEATURE_BOLD = "bold";
    public static final String FEATURE_ITALIC = "italic";
    public static final String FEATURE_UNDERLINE = "underline";
    public static final String FEATURE_STRIKETHROUGH = "strikethrough";
    public static final String FEATURE_PARAGRAPH_STYLE = "paragraphStyle";
    public static final String FEATURE_INDENT = "indent";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String DOCUMENT_CHANGED_PROPERTY = "document";
    public static final String OPERATION_LISTENERS_CHANGED_PROPERTY = "operationListeners";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String INPUT_ACTION = "action";
    public static final String INPUT_OPERATION = "operation";
    public static final String OPERATION_INSERT_IMAGE = "insertImage";
    public static final String OPERATION_INSERT_HYPERLINK = "insertHyperlink";
    public static final String OPERATION_INSERT_TABLE = "insertTable";
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_CONTROL_PANE_BUTTON_STYLE_NAME = "controlPaneButtonStyleName";
    public static final String PROPERTY_CONTROL_PANE_ROW_STYLE_NAME = "controlPaneRowStyleName";
    public static final String PROPERTY_CONTROL_PANE_SPLIT_PANE_STYLE_NAME = "controlPaneSplitPaneStyleName";
    public static final String PROPERTY_FEATURES = "features";
    public static final String PROPERTY_ICONS = "icons";
    public static final String PROPERTY_MENU_STYLE_NAME = "menuStyleName";
    public static final String PROPERTY_OVERRIDE_INSERT_HYPERLINK = "overrideInsertHyperlink";
    public static final String PROPERTY_OVERRIDE_INSERT_IMAGE = "overrideInsertImage";
    public static final String PROPERTY_OVERRIDE_INSERT_TABLE = "overrideInsertTable";
    public static final String PROPERTY_TOOLBAR_BUTTON_STYLE_NAME = "toolbarButtonStyleName";
    public static final String PROPERTY_TOOLBAR_PANEL_STYLE_NAME = "toolbarPanelStyleName";
    public static final String PROPERTY_WINDOW_PANE_STYLE_NAME = "windowPaneStyleName";
    private Document document;
    private DocumentListener documentListener = new DocumentListener(){
        private static final long serialVersionUID = 20070101L;

        public void documentUpdate(DocumentEvent e) {
            RichTextArea.this.firePropertyChange(RichTextArea.TEXT_CHANGED_PROPERTY, null, ((Document)e.getSource()).getText());
        }
    };

    public RichTextArea() {
        this((Document)new StringDocument());
    }

    public RichTextArea(Document document) {
        this.setDocument(document);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void addOperationListener(RichTextOperationListener l) {
        this.getEventListenerList().addListener(RichTextOperationListener.class, (EventListener)l);
        this.firePropertyChange(OPERATION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    private void fireActionPerformed() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent((Object)this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    private void fireOperationPerformed(String operationName) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(RichTextOperationListener.class);
        RichTextOperationEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new RichTextOperationEvent((Object)this, operationName);
            }
            ((RichTextOperationListener)listeners[i]).operationPerformed(e);
        }
    }

    public String getActionCommand() {
        return (String)this.get(PROPERTY_ACTION_COMMAND);
    }

    public FillImage getBackgroundImage() {
        return (FillImage)this.get(PROPERTY_BACKGROUND_IMAGE);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public String getControlPaneButtonStyleName() {
        return (String)this.get(PROPERTY_CONTROL_PANE_BUTTON_STYLE_NAME);
    }

    public String getControlPaneRowStyleName() {
        return (String)this.get(PROPERTY_CONTROL_PANE_ROW_STYLE_NAME);
    }

    public String getControlPaneSplitPaneStyleName() {
        return (String)this.get(PROPERTY_CONTROL_PANE_SPLIT_PANE_STYLE_NAME);
    }

    public Document getDocument() {
        return this.document;
    }

    public Map getFeatures() {
        return (Map)this.get(PROPERTY_FEATURES);
    }

    public Map getIcons() {
        return (Map)this.get(PROPERTY_ICONS);
    }

    public String getMenuStyleName() {
        return (String)this.get(PROPERTY_MENU_STYLE_NAME);
    }

    public String getText() {
        return this.document.getText();
    }

    public String getToolbarButtonStyleName() {
        return (String)this.get(PROPERTY_TOOLBAR_BUTTON_STYLE_NAME);
    }

    public String getToolbarPanelStyleName() {
        return (String)this.get(PROPERTY_TOOLBAR_PANEL_STYLE_NAME);
    }

    public String getWindowPaneStyleName() {
        return (String)this.get(PROPERTY_WINDOW_PANE_STYLE_NAME);
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public boolean hasOperationListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(RichTextOperationListener.class) != 0;
    }

    public boolean isOverrideInsertHyperlink() {
        Boolean value = (Boolean)this.get(PROPERTY_OVERRIDE_INSERT_HYPERLINK);
        return value != null && value != false;
    }

    public boolean isOverrideInsertImage() {
        Boolean value = (Boolean)this.get(PROPERTY_OVERRIDE_INSERT_IMAGE);
        return value != null && value != false;
    }

    public boolean isOverrideInsertTable() {
        Boolean value = (Boolean)this.get(PROPERTY_OVERRIDE_INSERT_TABLE);
        return value != null && value != false;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (TEXT_CHANGED_PROPERTY.equals(inputName)) {
            this.setText((String)inputValue);
        } else if (INPUT_ACTION.equals(inputName)) {
            this.fireActionPerformed();
        } else if (INPUT_OPERATION.equals(inputName)) {
            this.fireOperationPerformed((String)inputValue);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void removeOperationListener(RichTextOperationListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(RichTextOperationListener.class, (EventListener)l);
        this.firePropertyChange(OPERATION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.set(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setControlPaneButtonStyleName(String newValue) {
        this.set(PROPERTY_CONTROL_PANE_BUTTON_STYLE_NAME, newValue);
    }

    public void setControlPaneRowStyleName(String newValue) {
        this.set(PROPERTY_CONTROL_PANE_ROW_STYLE_NAME, newValue);
    }

    public void setControlPaneSplitPaneStyleName(String newValue) {
        this.set(PROPERTY_CONTROL_PANE_SPLIT_PANE_STYLE_NAME, newValue);
    }

    public void setDocument(Document newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Document may not be null.");
        }
        Document oldValue = this.getDocument();
        if (oldValue != null) {
            oldValue.removeDocumentListener(this.documentListener);
        }
        newValue.addDocumentListener(this.documentListener);
        this.document = newValue;
    }

    public void setFeatures(Map newValue) {
        this.set(PROPERTY_FEATURES, newValue);
    }

    public void setIcons(Map newValue) {
        this.set(PROPERTY_ICONS, newValue);
    }

    public void setMenuStyleName(String newValue) {
        this.set(PROPERTY_MENU_STYLE_NAME, newValue);
    }

    public void setOverrideInsertHyperlink(boolean newValue) {
        this.set(PROPERTY_OVERRIDE_INSERT_HYPERLINK, newValue);
    }

    public void setOverrideInsertImage(boolean newValue) {
        this.set(PROPERTY_OVERRIDE_INSERT_IMAGE, newValue);
    }

    public void setOverrideInsertTable(boolean newValue) {
        this.set(PROPERTY_OVERRIDE_INSERT_TABLE, newValue);
    }

    public void setText(String newValue) {
        this.getDocument().setText(newValue);
    }

    public void setToolbarButtonStyleName(String newValue) {
        this.set(PROPERTY_TOOLBAR_BUTTON_STYLE_NAME, newValue);
    }

    public void setToolbarPanelStyleName(String newValue) {
        this.set(PROPERTY_TOOLBAR_PANEL_STYLE_NAME, newValue);
    }

    public void setWindowPaneStyleName(String newValue) {
        this.set(PROPERTY_WINDOW_PANE_STYLE_NAME, newValue);
    }
}

