/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextapp.echo.app.Border;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.Font;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Label;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.event.ChangeEvent;
import nextapp.echo.app.event.ChangeListener;
import nextapp.echo.extras.app.event.TreeColumnModelEvent;
import nextapp.echo.extras.app.event.TreeColumnModelListener;
import nextapp.echo.extras.app.event.TreeExpansionEvent;
import nextapp.echo.extras.app.event.TreeExpansionListener;
import nextapp.echo.extras.app.event.TreeModelEvent;
import nextapp.echo.extras.app.event.TreeModelListener;
import nextapp.echo.extras.app.tree.AbstractTreeModel;
import nextapp.echo.extras.app.tree.DefaultTreeCellRenderer;
import nextapp.echo.extras.app.tree.DefaultTreeColumnModel;
import nextapp.echo.extras.app.tree.DefaultTreeSelectionModel;
import nextapp.echo.extras.app.tree.TreeCellRenderer;
import nextapp.echo.extras.app.tree.TreeColumn;
import nextapp.echo.extras.app.tree.TreeColumnModel;
import nextapp.echo.extras.app.tree.TreeModel;
import nextapp.echo.extras.app.tree.TreePath;
import nextapp.echo.extras.app.tree.TreeSelectionModel;

public class Tree
extends Component {
    private Renderer renderer = new Renderer();
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_HEADER_VISIBLE = "headerVisible";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_LINE_STYLE = "lineStyle";
    public static final String PROPERTY_NODE_CLOSED_ICON = "nodeClosedIcon";
    public static final String PROPERTY_NODE_CLOSED_BOTTOM_ICON = "nodeClosedBottomIcon";
    public static final String PROPERTY_NODE_OPEN_ICON = "nodeOpenIcon";
    public static final String PROPERTY_NODE_OPEN_BOTTOM_ICON = "nodeOpenBottomIcon";
    public static final String PROPERTY_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String PROPERTY_ROLLOVER_BACKGROUND_IMAGE = "rolloverBackgroundImage";
    public static final String PROPERTY_ROLLOVER_BORDER = "rolloverBorder";
    public static final String PROPERTY_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String PROPERTY_ROLLOVER_FONT = "rolloverFont";
    public static final String PROPERTY_ROLLOVER_FOREGROUND = "rolloverForeground";
    public static final String PROPERTY_ROOT_VISIBLE = "rootVisible";
    public static final String PROPERTY_SELECTION_BACKGROUND = "selectionBackground";
    public static final String PROPERTY_SELECTION_BACKGROUND_IMAGE = "selectionBackgroundImage";
    public static final String PROPERTY_SELECTION_BORDER = "selectionBorder";
    public static final String PROPERTY_SELECTION_ENABLED = "selectionEnabled";
    public static final String PROPERTY_SELECTION_FONT = "selectionFont";
    public static final String PROPERTY_SELECTION_FOREGROUND = "selectionForeground";
    public static final String PROPERTY_SHOWS_ROOT_HANDLE = "showsRootHandle";
    public static final String PROPERTY_WIDTH = "width";
    public static final String EXPAND_ACTION = "expand";
    public static final String INPUT_ACTION = "action";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String AUTO_CREATE_COLUMNS_FROM_MODEL_CHANGED_PROPERTY = "autoCreateColumnsFromModel";
    public static final String CELL_RENDERER_CHANGED_PROPERTY = "cellRenderer";
    public static final String COLUMN_MODEL_CHANGED_PROPERTY = "columnModel";
    public static final String COLUMN_WIDTH_CHANGED_PROPERTY = "columnWidth";
    public static final String DEFAULT_HEADER_RENDERER_CHANGED_PROPERTY = "defaultHeaderRenderer";
    public static final String DEFAULT_RENDERER_CHANGED_PROPERTY = "defaultRenderer";
    public static final String EXPANSION_STATE_CHANGED_PROPERTY = "expansionState";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String SELECTION_CHANGED_PROPERTY = "selection";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY = "selectionModel";
    public static final String SELECTION_MODE_CHANGED_PROPERTY = "selectionMode";
    public static final int LINE_STYLE_NONE = 0;
    public static final int LINE_STYLE_SOLID = 1;
    public static final int LINE_STYLE_DOTTED = 2;
    public static final int HEADER_ROW = -1;
    private static final TreeCellRenderer DEFAULT_TREE_CELL_RENDERER = new DefaultTreeCellRenderer();
    private TreeModelListener modelListener = new TreeModelListener(){

        public void treeStructureChanged(TreeModelEvent e) {
            Tree.this.invalidate();
            if (Tree.this.isAutoCreateColumnsFromModel()) {
                Tree.this.createDefaultColumnsFromModel();
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            Tree.this.invalidate();
            TreePath removedPath = e.getTreePath();
            TreePath[] selectionPaths = Tree.this.getSelectionModel().getSelectionPaths();
            for (int i = 0; i < selectionPaths.length; ++i) {
                TreePath selectionPath = selectionPaths[i];
                if (!removedPath.isDescendant(selectionPath)) continue;
                Tree.this.getSelectionModel().removeSelectionPath(selectionPath);
            }
            if (Tree.this.isAutoCreateColumnsFromModel()) {
                Tree.this.createDefaultColumnsFromModel();
            }
        }

        public void treeNodesChanged(TreeModelEvent e) {
            Tree.this.invalidate();
            if (Tree.this.isAutoCreateColumnsFromModel()) {
                Tree.this.createDefaultColumnsFromModel();
            }
        }

        public void treeNodesAdded(TreeModelEvent e) {
            Tree.this.invalidate();
            if (Tree.this.isAutoCreateColumnsFromModel()) {
                Tree.this.createDefaultColumnsFromModel();
            }
        }
    };
    private TreeColumnModelListener columnModelListener = new TreeColumnModelListener(){

        public void columnAdded(TreeColumnModelEvent e) {
            Tree.this.invalidate();
        }

        public void columnMoved(TreeColumnModelEvent e) {
            Tree.this.invalidate();
        }

        public void columnRemoved(TreeColumnModelEvent e) {
            Tree.this.invalidate();
        }

        public void columnResized(TreeColumnModelEvent e) {
            Tree.this.firePropertyChange(Tree.COLUMN_WIDTH_CHANGED_PROPERTY, null, null);
        }
    };
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            if (!Tree.this.suppressChangeNotifications) {
                Tree.this.firePropertyChange(Tree.SELECTION_CHANGED_PROPERTY, null, null);
            }
        }
    };
    private PropertyChangeListener propertyChangeListener = new TreeSelectionModelListener();
    private TreeModel model;
    private TreeColumnModel columnModel;
    private TreeSelectionModel selectionModel;
    private Map defaultRendererMap = new HashMap();
    private TreeCellRenderer defaultHeaderRenderer;
    private Set expandedPaths = new HashSet();
    private List rowToTreePathCache = new ArrayList();
    private Map treePathToComponentCache = new HashMap();
    private boolean valid = false;
    private TreeCellRenderer cellRenderer;
    private boolean autoCreateColumnsFromModel;
    private boolean suppressChangeNotifications = false;

    public Tree() {
        this(new AbstractTreeModel(){

            public boolean isLeaf(Object object) {
                return true;
            }

            public Object getValueAt(Object node, int column) {
                return node;
            }

            public Object getRoot() {
                return "";
            }

            public int getIndexOfChild(Object parent, Object child) {
                return 0;
            }

            public int getColumnCount() {
                return 1;
            }

            public int getChildCount(Object parent) {
                return 0;
            }

            public Object getChild(Object parent, int index) {
                return null;
            }
        });
    }

    public Tree(TreeModel model) {
        this(model, null);
    }

    public Tree(TreeModel model, TreeColumnModel columnModel) {
        if (columnModel == null) {
            this.setColumnModel(new DefaultTreeColumnModel());
            this.setAutoCreateColumnsFromModel(true);
        } else {
            this.setColumnModel(columnModel);
        }
        this.setModel(model);
        this.setSelectionModel(new DefaultTreeSelectionModel());
        this.setCellRenderer(DEFAULT_TREE_CELL_RENDERER);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void collapse(TreePath path) {
        this.setExpandedState(path, false);
    }

    public void collapseAll() {
        LinkedList collapseList = new LinkedList(this.expandedPaths);
        Iterator it = collapseList.iterator();
        while (it.hasNext()) {
            TreePath path = (TreePath)it.next();
            this.setExpandedState(path, false);
        }
    }

    protected void collapseAll(TreePath path) {
        LinkedList collapseList = new LinkedList(this.expandedPaths);
        Iterator it = collapseList.iterator();
        while (it.hasNext()) {
            TreePath expandedPath = (TreePath)it.next();
            if (!path.isDescendant(expandedPath)) continue;
            this.setExpandedState(expandedPath, false);
        }
    }

    public void createDefaultColumnsFromModel() {
        if (this.model != null) {
            while (this.columnModel.getColumnCount() > 0) {
                this.columnModel.removeColumn(this.columnModel.getColumn(0));
            }
            int columnCount = this.model.getColumnCount();
            for (int index = 0; index < columnCount; ++index) {
                this.columnModel.addColumn(new TreeColumn(index));
            }
        }
    }

    public void expand(TreePath path) {
        this.setExpandedState(path, true);
    }

    public void expandAll() {
        Object root = this.model.getRoot();
        if (root == null) {
            return;
        }
        this.expandAll(new TreePath(root));
    }

    protected void expandAll(TreePath path) {
        this.setExpandedState(path, true);
        Object value = path.getLastPathComponent();
        int childCount = this.model.getChildCount(value);
        for (int i = 0; i < childCount; ++i) {
            this.expandAll(path.pathByAddingChild(this.model.getChild(value, i)));
        }
    }

    private void fireActionEvent() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent((Object)this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return (String)this.get(PROPERTY_ACTION_COMMAND);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public TreeColumnModel getColumnModel() {
        return this.columnModel;
    }

    public TreeCellRenderer getDefaultHeaderRenderer() {
        return this.defaultHeaderRenderer;
    }

    public TreeCellRenderer getDefaultRenderer(Class columnClass) {
        return (TreeCellRenderer)this.defaultRendererMap.get(columnClass);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public void dispose() {
        this.model.removeTreeModelListener(this.modelListener);
    }

    public void init() {
        this.model.addTreeModelListener(this.modelListener);
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (SELECTION_CHANGED_PROPERTY.equals(inputName)) {
            this.setSelectedIndices((int[])inputValue);
        } else if (EXPANSION_STATE_CHANGED_PROPERTY.equals(inputName)) {
            TreePath path;
            int row = (Integer)inputValue;
            this.setExpandedState(path, !this.isExpanded(path = this.getPathForRow(row)));
        } else if (INPUT_ACTION.equals(inputName)) {
            this.fireActionEvent();
        }
    }

    public void setAutoCreateColumnsFromModel(boolean newValue) {
        boolean oldValue = this.autoCreateColumnsFromModel;
        this.autoCreateColumnsFromModel = newValue;
        if (!oldValue && newValue) {
            this.createDefaultColumnsFromModel();
        }
        this.firePropertyChange(AUTO_CREATE_COLUMNS_FROM_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setActionCommand(String newValue) {
        this.set(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setCellRenderer(TreeCellRenderer newValue) {
        this.invalidate();
        TreeCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = newValue;
        this.firePropertyChange(CELL_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setColumnModel(TreeColumnModel newValue) {
        this.invalidate();
        if (newValue == null) {
            throw new IllegalArgumentException("The model may not be null.");
        }
        TreeColumnModel oldValue = this.columnModel;
        if (oldValue != null) {
            oldValue.removeColumnModelListener(this.columnModelListener);
        }
        this.columnModel = newValue;
        newValue.addColumnModelListener(this.columnModelListener);
        this.firePropertyChange(COLUMN_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDefaultHeaderRenderer(TreeCellRenderer newValue) {
        this.invalidate();
        TreeCellRenderer oldValue = this.defaultHeaderRenderer;
        this.defaultHeaderRenderer = newValue;
        this.firePropertyChange(DEFAULT_HEADER_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDefaultRenderer(Class columnClass, TreeCellRenderer newValue) {
        this.invalidate();
        if (newValue == null) {
            this.defaultRendererMap.remove(columnClass);
        } else {
            this.defaultRendererMap.put(columnClass, newValue);
        }
        this.firePropertyChange(DEFAULT_RENDERER_CHANGED_PROPERTY, null, null);
    }

    public void setExpandedState(TreePath treePath, boolean state) {
        if (this.model.isLeaf(treePath.getLastPathComponent())) {
            return;
        }
        if (this.expandedPaths.contains(treePath) == state) {
            return;
        }
        if (state) {
            TreePath topExpanded = null;
            for (TreePath parentPath = treePath; parentPath != null; parentPath = parentPath.getParentPath()) {
                if (this.expandedPaths.contains(parentPath)) continue;
                this.expandedPaths.add(parentPath);
                topExpanded = parentPath;
                this.fireExpansionStateUpdate(parentPath, state);
            }
            if (topExpanded != null && this.valid) {
                this.renderer.update(topExpanded, true);
            }
        } else {
            this.expandedPaths.remove(treePath);
            this.renderer.update(treePath, false);
            this.fireExpansionStateUpdate(treePath, state);
        }
    }

    public void setHeaderVisible(boolean newValue) {
        this.invalidate();
        this.set(PROPERTY_HEADER_VISIBLE, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    protected void fireExpansionStateUpdate(TreePath treePath, boolean newState) {
        TreeExpansionEvent event = new TreeExpansionEvent(this, treePath);
        EventListener[] listeners = this.getEventListenerList().getListeners(TreeExpansionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            TreeExpansionListener l = (TreeExpansionListener)listeners[i];
            if (newState) {
                l.treeExpanded(event);
                continue;
            }
            l.treeCollapsed(event);
        }
        this.firePropertyChange(EXPANSION_STATE_CHANGED_PROPERTY, null, null);
    }

    public boolean isAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public boolean isExpanded(int row) {
        return this.isExpanded(this.getPathForRow(row));
    }

    public boolean isExpanded(TreePath treePath) {
        return this.expandedPaths.contains(treePath);
    }

    public boolean isHeaderVisible() {
        Boolean value = (Boolean)this.get(PROPERTY_HEADER_VISIBLE);
        return value == null ? false : value;
    }

    public boolean isRolloverEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    public boolean isRootVisible() {
        Boolean value = (Boolean)this.get(PROPERTY_ROOT_VISIBLE);
        return value == null ? true : value;
    }

    public boolean isSelectionEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_SELECTION_ENABLED);
        return value == null ? false : value;
    }

    public boolean isShowsRootHandle() {
        Boolean value = (Boolean)this.get(PROPERTY_SHOWS_ROOT_HANDLE);
        return value == null ? false : value;
    }

    public TreePath getPathForRow(int row) {
        if (row == -1) {
            return null;
        }
        return (TreePath)this.rowToTreePathCache.get(row);
    }

    public int getRowForPath(TreePath path) {
        for (int i = 0; i < this.rowToTreePathCache.size(); ++i) {
            if (!this.rowToTreePathCache.get(i).equals(path)) continue;
            return i;
        }
        return -1;
    }

    public Color getRolloverBackground() {
        return (Color)this.get(PROPERTY_ROLLOVER_BACKGROUND);
    }

    public FillImage getRolloverBackgroundImage() {
        return (FillImage)this.get(PROPERTY_ROLLOVER_BACKGROUND_IMAGE);
    }

    public Border getRolloverBorder() {
        return (Border)this.get(PROPERTY_ROLLOVER_BORDER);
    }

    public Font getRolloverFont() {
        return (Font)this.get(PROPERTY_ROLLOVER_FONT);
    }

    public Color getRolloverForeground() {
        return (Color)this.get(PROPERTY_ROLLOVER_FOREGROUND);
    }

    public Color getSelectionBackground() {
        return (Color)this.get(PROPERTY_SELECTION_BACKGROUND);
    }

    public FillImage getSelectionBackgroundImage() {
        return (FillImage)this.get(PROPERTY_SELECTION_BACKGROUND_IMAGE);
    }

    public Border getSelectionBorder() {
        return (Border)this.get(PROPERTY_SELECTION_BORDER);
    }

    public Font getSelectionFont() {
        return (Font)this.get(PROPERTY_SELECTION_FONT);
    }

    public Color getSelectionForeground() {
        return (Color)this.get(PROPERTY_SELECTION_FOREGROUND);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public Component getComponent(int row, int column) {
        if (this.rowToTreePathCache.isEmpty()) {
            return null;
        }
        if (row >= this.rowToTreePathCache.size()) {
            return null;
        }
        return this.getComponent(this.getPathForRow(row), column);
    }

    public Component getComponent(TreePath path, int column) {
        if (this.columnModel.getColumnCount() == 1) {
            return (Component)this.treePathToComponentCache.get(path);
        }
        List list = (List)this.treePathToComponentCache.get(path);
        return (Component)list.get(column);
    }

    public int getLineStyle() {
        Integer oLineStyle = (Integer)this.get(PROPERTY_LINE_STYLE);
        if (oLineStyle == null) {
            return 2;
        }
        return oLineStyle;
    }

    public ImageReference getNodeClosedIcon() {
        return (ImageReference)this.get(PROPERTY_NODE_CLOSED_ICON);
    }

    public ImageReference getNodeClosedBottomIcon() {
        return (ImageReference)this.get(PROPERTY_NODE_CLOSED_BOTTOM_ICON);
    }

    public ImageReference getNodeOpenIcon() {
        return (ImageReference)this.get(PROPERTY_NODE_OPEN_ICON);
    }

    public ImageReference getNodeOpenBottomIcon() {
        return (ImageReference)this.get(PROPERTY_NODE_OPEN_BOTTOM_ICON);
    }

    private void invalidate() {
        this.valid = false;
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setModel(TreeModel newValue) {
        this.invalidate();
        if (newValue == null) {
            throw new IllegalArgumentException("The model may not be null.");
        }
        TreeModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeTreeModelListener(this.modelListener);
        }
        newValue.addTreeModelListener(this.modelListener);
        this.model = newValue;
        this.expandedPaths.clear();
        if (this.isAutoCreateColumnsFromModel()) {
            this.createDefaultColumnsFromModel();
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldValue, newValue);
        if (this.model.getRoot() != null) {
            this.setExpandedState(new TreePath(this.model.getRoot()), true);
        }
    }

    public void setLineStyle(int newValue) {
        this.set(PROPERTY_LINE_STYLE, new Integer(newValue));
    }

    public void setNodeClosedIcon(ImageReference newValue) {
        this.set(PROPERTY_NODE_CLOSED_ICON, newValue);
    }

    public void setNodeClosedBottomIcon(ImageReference newValue) {
        this.set(PROPERTY_NODE_CLOSED_BOTTOM_ICON, newValue);
    }

    public void setNodeOpenIcon(ImageReference newValue) {
        this.set(PROPERTY_NODE_OPEN_ICON, newValue);
    }

    public void setNodeOpenBottomIcon(ImageReference newValue) {
        this.set(PROPERTY_NODE_OPEN_BOTTOM_ICON, newValue);
    }

    public void setRolloverBackground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND, newValue);
    }

    public void setRolloverBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND_IMAGE, newValue);
    }

    public void setRolloverBorder(Border newValue) {
        this.set(PROPERTY_ROLLOVER_BORDER, newValue);
    }

    public void setRolloverEnabled(boolean newValue) {
        this.set(PROPERTY_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setRolloverFont(Font newValue) {
        this.set(PROPERTY_ROLLOVER_FONT, newValue);
    }

    public void setRolloverForeground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_FOREGROUND, newValue);
    }

    public void setRootVisible(boolean newValue) {
        this.set(PROPERTY_ROOT_VISIBLE, newValue);
    }

    private void setSelectedIndices(int[] selectedIndices) {
        this.suppressChangeNotifications = true;
        TreeSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.clearSelection();
        for (int i = 0; i < selectedIndices.length; ++i) {
            selectionModel.addSelectionPath(this.getPathForRow(selectedIndices[i]));
        }
        this.suppressChangeNotifications = false;
        this.firePropertyChange(SELECTION_CHANGED_PROPERTY, null, selectedIndices);
    }

    public void setSelectionBackground(Color newValue) {
        this.set(PROPERTY_SELECTION_BACKGROUND, newValue);
    }

    public void setSelectionBackgroundImage(FillImage newValue) {
        this.set(PROPERTY_SELECTION_BACKGROUND_IMAGE, newValue);
    }

    public void setSelectionBorder(Border newValue) {
        this.set(PROPERTY_SELECTION_BORDER, newValue);
    }

    public void setSelectionEnabled(boolean newValue) {
        this.set(PROPERTY_SELECTION_ENABLED, newValue);
    }

    public void setSelectionForeground(Color newValue) {
        this.set(PROPERTY_SELECTION_FOREGROUND, newValue);
    }

    public void setSelectionFont(Font newValue) {
        this.set(PROPERTY_SELECTION_FONT, newValue);
    }

    public void setSelectionModel(TreeSelectionModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Selection model may not be null.");
        }
        TreeSelectionModel oldValue = this.selectionModel;
        if (oldValue != null) {
            oldValue.removeChangeListener(this.changeListener);
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        newValue.addChangeListener(this.changeListener);
        newValue.addPropertyChangeListener(this.propertyChangeListener);
        this.selectionModel = newValue;
        this.firePropertyChange(SELECTION_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setShowsRootHandle(boolean newValue) {
        this.set(PROPERTY_SHOWS_ROOT_HANDLE, newValue);
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }

    public void validate() {
        super.validate();
        while (!this.valid) {
            this.valid = true;
            this.renderer.fullUpdate();
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        this.getEventListenerList().addListener(TreeExpansionListener.class, (EventListener)l);
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        this.getEventListenerList().removeListener(TreeExpansionListener.class, (EventListener)l);
    }

    private class TreeSelectionModelListener
    implements PropertyChangeListener,
    Serializable {
        private TreeSelectionModelListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (Tree.SELECTION_MODE_CHANGED_PROPERTY.equals(evt.getPropertyName())) {
                Tree.this.firePropertyChange(Tree.SELECTION_MODE_CHANGED_PROPERTY, evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private class Renderer
    implements Serializable {
        private int columnCount;
        private int row;
        private TreeColumn[] treeColumns;
        private TreeCellRenderer[] columnRenderers;

        private Renderer() {
        }

        private void doRender() {
            Object root = Tree.this.model.getRoot();
            if (Tree.this.isHeaderVisible()) {
                this.renderHeader();
            }
            this.doRenderNode(new TreePath(root));
        }

        private void init() {
            this.columnCount = Tree.this.columnModel.getColumnCount();
            this.treeColumns = new TreeColumn[this.columnCount];
            this.columnRenderers = new TreeCellRenderer[this.columnCount];
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                Class columnClass;
                this.treeColumns[columnIndex] = Tree.this.columnModel.getColumn(columnIndex);
                TreeCellRenderer renderer = this.treeColumns[columnIndex].getCellRenderer();
                if (renderer == null && (renderer = Tree.this.getDefaultRenderer(columnClass = Tree.this.model.getColumnClass(this.treeColumns[columnIndex].getModelIndex()))) == null && (renderer = Tree.this.getCellRenderer()) == null) {
                    renderer = DEFAULT_TREE_CELL_RENDERER;
                }
                this.columnRenderers[columnIndex] = renderer;
            }
        }

        private void renderHeader() {
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                Component renderedComponent;
                TreeCellRenderer headerRenderer;
                int modelColumnIndex = this.treeColumns[columnIndex].getModelIndex();
                Object headerValue = this.treeColumns[columnIndex].getHeaderValue();
                if (headerValue == null) {
                    headerValue = Tree.this.model.getColumnName(modelColumnIndex);
                }
                if ((headerRenderer = this.treeColumns[columnIndex].getHeaderRenderer()) == null && (headerRenderer = Tree.this.defaultHeaderRenderer) == null) {
                    headerRenderer = DEFAULT_TREE_CELL_RENDERER;
                }
                if ((renderedComponent = headerRenderer.getTreeCellRendererComponent(Tree.this, null, headerValue, modelColumnIndex, -1, false)) == null) {
                    renderedComponent = new Label();
                }
                Tree.this.add(renderedComponent);
                this.cacheComponent(null, columnIndex, renderedComponent);
            }
        }

        private void doRenderNode(TreePath treePath) {
            int cacheSize;
            Object value = treePath.getLastPathComponent();
            if (!Tree.this.treePathToComponentCache.containsKey(treePath)) {
                this.renderNodeComponents(treePath);
            }
            if ((cacheSize = Tree.this.rowToTreePathCache.size()) == 0 || this.row >= cacheSize || !Tree.this.rowToTreePathCache.get(this.row).equals(treePath)) {
                Tree.this.rowToTreePathCache.add(this.row, treePath);
            }
            ++this.row;
            if (Tree.this.isExpanded(treePath)) {
                int childCount = Tree.this.model.getChildCount(value);
                for (int i = 0; i < childCount; ++i) {
                    Object childValue = Tree.this.model.getChild(value, i);
                    this.doRenderNode(treePath.pathByAddingChild(childValue));
                }
            }
        }

        private void renderNodeComponents(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            boolean leaf = Tree.this.model.getChildCount(node) == 0;
            for (int i = 0; i < this.columnCount; ++i) {
                int modelColumnIndex = this.treeColumns[i].getModelIndex();
                Object modelValue = Tree.this.model.getValueAt(node, modelColumnIndex);
                Component renderedComponent = this.columnRenderers[i].getTreeCellRendererComponent(Tree.this, treePath, modelValue, modelColumnIndex, this.row, leaf);
                if (renderedComponent == null) {
                    renderedComponent = new Label();
                }
                Tree.this.add(renderedComponent);
                this.cacheComponent(treePath, i, renderedComponent);
            }
        }

        private void cacheComponent(TreePath treePath, int column, Component component) {
            if (1 == this.columnCount) {
                Tree.this.treePathToComponentCache.put(treePath, component);
            } else {
                List<Component> list;
                if (column == 0) {
                    list = new ArrayList();
                    Tree.this.treePathToComponentCache.put(treePath, list);
                } else {
                    list = (List)Tree.this.treePathToComponentCache.get(treePath);
                }
                list.add(component);
            }
        }

        void update(TreePath path, boolean newState) {
            this.init();
            this.row = Tree.this.getRowForPath(path);
            if (this.row == -1) {
                this.row = Tree.this.rowToTreePathCache.size();
            }
            if (newState) {
                this.doRenderNode(path);
            } else {
                this.doCollapse(path);
            }
        }

        private void doCollapse(TreePath path) {
            Object value = path.getLastPathComponent();
            if (Tree.this.model.getChildCount(value) == 0) {
                return;
            }
            int startRow = Tree.this.getRowForPath(path) + 1;
            TreePath siblingPath = this.getSiblingPath(path);
            int endRow = siblingPath == null ? Tree.this.rowToTreePathCache.size() : Tree.this.getRowForPath(siblingPath);
            for (int i = startRow; i < endRow; ++i) {
                Tree.this.rowToTreePathCache.remove(startRow);
            }
        }

        private TreePath getSiblingPath(TreePath path) {
            TreePath parentPath = path.getParentPath();
            if (parentPath == null) {
                return null;
            }
            Object parentValue = parentPath.getLastPathComponent();
            int index = Tree.this.model.getIndexOfChild(parentValue, path.getLastPathComponent());
            if (index == Tree.this.model.getChildCount(parentValue) - 1) {
                return this.getSiblingPath(parentPath);
            }
            Object siblingValue = Tree.this.model.getChild(parentValue, index + 1);
            return parentPath.pathByAddingChild(siblingValue);
        }

        void fullUpdate() {
            this.init();
            Tree.this.removeAll();
            Tree.this.treePathToComponentCache.clear();
            Tree.this.rowToTreePathCache.clear();
            this.row = 0;
            this.doRender();
        }
    }
}

