/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import nextapp.echo.app.event.EventListenerList;
import nextapp.echo.extras.app.event.TreeColumnModelEvent;
import nextapp.echo.extras.app.event.TreeColumnModelListener;
import nextapp.echo.extras.app.tree.TreeColumn;
import nextapp.echo.extras.app.tree.TreeColumnModel;

public class DefaultTreeColumnModel
implements TreeColumnModel {
    private ColumnChangeForwarder columnChangeForwarder = new ColumnChangeForwarder();
    private List columns = new ArrayList();
    protected EventListenerList listenerList = new EventListenerList();

    public void addColumn(TreeColumn column) {
        this.columns.add(column);
        column.addPropertyChangeListener(this.columnChangeForwarder);
        this.fireColumnAdded(new TreeColumnModelEvent(this, -1, this.columns.size() - 1));
    }

    public void addColumnModelListener(TreeColumnModelListener l) {
        this.listenerList.addListener(TreeColumnModelListener.class, (EventListener)l);
    }

    protected void fireColumnAdded(TreeColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TreeColumnModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TreeColumnModelListener)listeners[index]).columnAdded(e);
        }
    }

    protected void fireColumnMoved(TreeColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TreeColumnModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TreeColumnModelListener)listeners[index]).columnMoved(e);
        }
    }

    protected void fireColumnRemoved(TreeColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TreeColumnModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TreeColumnModelListener)listeners[index]).columnRemoved(e);
        }
    }

    protected void fireColumnResized(TreeColumnModelEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TreeColumnModelListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((TreeColumnModelListener)listeners[index]).columnResized(e);
        }
    }

    public TreeColumn getColumn(int index) {
        if (this.getColumnCount() - 1 < index) {
            return null;
        }
        return (TreeColumn)this.columns.get(index);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Null not allowed as identifier value.");
        }
        Iterator it = this.columns.iterator();
        int index = 0;
        while (it.hasNext()) {
            TreeColumn column = (TreeColumn)it.next();
            if (identifier.equals(column.getIdentifier())) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("No column found with specified identifier: " + identifier);
    }

    public Iterator getColumns() {
        return this.columns.iterator();
    }

    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException("No column exists at index: " + columnIndex);
        }
        if (newIndex < 0 || newIndex >= this.columns.size()) {
            throw new IllegalArgumentException("Attempt to move column to invalid index: " + newIndex);
        }
        TreeColumn column = (TreeColumn)this.columns.remove(columnIndex);
        this.columns.add(newIndex, column);
        this.fireColumnMoved(new TreeColumnModelEvent(this, columnIndex, newIndex));
    }

    public void removeColumn(TreeColumn column) {
        int columnIndex = this.columns.indexOf(column);
        if (columnIndex == -1) {
            return;
        }
        column.removePropertyChangeListener(this.columnChangeForwarder);
        this.columns.remove(columnIndex);
        this.fireColumnAdded(new TreeColumnModelEvent(this, columnIndex, -1));
    }

    public void removeColumnModelListener(TreeColumnModelListener l) {
        this.listenerList.removeListener(TreeColumnModelListener.class, (EventListener)l);
    }

    private class ColumnChangeForwarder
    implements PropertyChangeListener,
    Serializable {
        private ColumnChangeForwarder() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int index = DefaultTreeColumnModel.this.columns.indexOf(evt.getSource());
            TreeColumnModelEvent event = new TreeColumnModelEvent(DefaultTreeColumnModel.this, index, index);
            DefaultTreeColumnModel.this.fireColumnResized(event);
        }
    }
}

